<?php
/**
 * Plugin Name: Make FAQ by makeWeb
 * Plugin URI: https://makeweb.com/plugins/make-faq
 * Description: A user-friendly, post-driven FAQ plugin with advanced functionality and SEO benefits.
 * Version: 1.6.31
 * Author: makeWeb
 * Author URI: https://makeweb.com
 * Text Domain: make-faq
 * Domain Path: /languages
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

// Define plugin constants
define('MAKE_FAQ_VERSION', '1.6.30');
define('MAKE_FAQ_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('MAKE_FAQ_PLUGIN_URL', plugin_dir_url(__FILE__));
define('MAKE_FAQ_PLUGIN_BASENAME', plugin_basename(__FILE__));

/**
 * The code that runs during plugin activation.
 */
function activate_make_faq() {
    require_once MAKE_FAQ_PLUGIN_DIR . 'includes/class-make-faq-activator.php';
    Make_FAQ_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 */
function deactivate_make_faq() {
    require_once MAKE_FAQ_PLUGIN_DIR . 'includes/class-make-faq-deactivator.php';
    Make_FAQ_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_make_faq');
register_deactivation_hook(__FILE__, 'deactivate_make_faq');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
// Try to load Composer autoloader if present (for updater and any vendor libs)
if (file_exists(MAKE_FAQ_PLUGIN_DIR . 'vendor/autoload.php')) {
    require_once MAKE_FAQ_PLUGIN_DIR . 'vendor/autoload.php';
}

////////////////////////// UPDATES //////////////////////////
// ID, Key, __FILE__
if (class_exists('makeUpdate')) {
    try {
        $updater = new makeUpdate("9543", "yat.rkc3PVM9ykf4uqj", __FILE__);
    } catch (Exception $e) {
        // Silently ignore updater initialization errors to avoid breaking the plugin
    }
}

require_once MAKE_FAQ_PLUGIN_DIR . 'includes/class-make-faq.php';

/**
 * Begins execution of the plugin.
 */
function run_make_faq() {
    $plugin = new Make_FAQ();
    $plugin->run();
}
run_make_faq();