# Make FAQ by makeWeb

A user-friendly, post-driven FAQ plugin that provides advanced functionality and SEO benefits as standard.

## Description

**Make FAQ by makeWeb** is a powerful WordPress plugin designed to create and manage FAQs on your website. Built on a custom post type architecture, it features a unique admin interface that dramatically simplifies the editing and management process.

### Key Features

- **Enhanced Admin Interface**: A "quick edit on steroids" approach with a custom modal window for editing FAQs without leaving the main list view
- **Post-Driven Architecture**: Uses WordPress custom post types with the question as the title and the answer as the content
- **Simplified Editor Experience**: A minimalist editor for FAQ answers with essential formatting tools
- **Flexible Output Options**:
  - Gutenberg Block
  - Shortcode
  - Divi Module
- **SEO-First Design**: Automatic FAQPage schema markup generation and accessible HTML
- **Premium Features Included**:
  - Search and filter functionality
  - Analytics dashboard
  - Bulk import/export tools
- **Extensible**: Well-documented hooks and filters for developers

## Installation

1. Upload the `make-faq` folder to the `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Go to 'FAQs' in your WordPress admin menu to start creating FAQs

## Usage

### Gutenberg Block

Use the "FAQ Display" block to add FAQs to your pages:

1. Add the block to your page
2. Configure the block settings to select categories, tags, or specific FAQs
3. Choose the display style (accordion, toggle, or list)
4. Save your page

### Shortcode

Use the `[makefaq]` shortcode to display FAQs:

```
[makefaq category="general" display="accordion" orderby="date" order="DESC" limit="5"]
```

Parameters:
- `category`: Filter by category slug (optional)
- `tag`: Filter by tag slug (optional)
- `ids`: Comma-separated list of FAQ IDs (optional)
- `display`: Display style - 'accordion', 'toggle', or 'list' (default: 'accordion')
- `orderby`: Order by 'date', 'title', or 'rand' (default: 'date')
- `order`: 'ASC' or 'DESC' (default: 'DESC')
- `limit`: Number of FAQs to display, -1 for all (default: -1)
- `class`: Additional CSS class (optional)

### Divi Module

If you're using Divi, you can use the "FAQ Display" module:

1. Add the module to your page
2. Configure the module settings
3. Save your page

The Divi modules provide a simple way to add FAQs to your Divi layouts with all the styling options available in the module settings.

## Search Functionality

You can add a search form to filter your FAQs using:

1. The "FAQ Search" Gutenberg block
2. The `[makefaq_search]` shortcode
3. The "FAQ Search" Divi module

The search functionality filters FAQs directly on the page, hiding items that don't match the search term. The search term is also added to the URL as a query parameter, allowing you to share direct links to filtered results.

### Shortcode

```
[makefaq_search placeholder="Search FAQs..." button="Search" category="general" tag="important"]
```

Parameters:
- `placeholder`: Placeholder text for the search input (default: 'Search FAQs...')
- `button`: Text for the search button (default: 'Search')
- `category`: Filter by category slug (optional)
- `tag`: Filter by tag slug (optional)
- `class`: Additional CSS class (optional)

## Analytics

View FAQ analytics by going to FAQs > Analytics in your WordPress admin menu. This shows:

- Most popular FAQs based on view count
- Search analytics showing what users are searching for

## Import/Export

Import or export your FAQs in CSV or JSON format by going to FAQs > Import/Export in your WordPress admin menu.

## Developer Documentation

### Hooks and Filters

The plugin provides several hooks and filters for customization:

- `makefaq_faq_item_question`: Filter the FAQ question before display
- `makefaq_faq_item_content`: Filter the FAQ answer before display
- `makefaq_faq_display_styles`: Filter the available display styles
- `makefaq_schema_enabled`: Filter whether schema markup is enabled
- `makefaq_schema_data`: Filter the schema data before output

## Version History

### 1.6.1
- Improved Divi module styling by implementing ET_Builder_Element::set_style()
- Fixed CSS selector issues with %%order_class%% placeholders
- Enhanced compatibility with Divi's styling system
- Resolved styling inconsistencies in Divi modules

### 1.6.0
- Removed Visual Builder support from Divi modules
- Simplified Divi module implementation to use standard rendering
- Removed React/JSX components and build system
- Improved stability and compatibility with Divi Builder

### 1.5.1
- Fixed React Component reference error in Divi modules
- Updated JSX files to import Component directly from React
- Improved stability of Visual Builder rendering

### 1.5.0
- Implemented proper Divi Extension structure for better Visual Builder integration
- Fixed blank module rendering in Divi Visual Builder
- Added dedicated frontend and builder scripts for Divi modules
- Enhanced component registration with Divi's Visual Builder API
- Improved settings fields display in the Visual Builder

### 1.4.4
- Fixed "module is not defined" JavaScript error in Divi modules
- Updated webpack configuration to use UMD format for browser compatibility
- Improved React and ReactDOM loading in Visual Builder
- Enhanced module initialization for better browser support

### 1.4.3
- Implemented full JSX support for Divi modules
- Added build system with Webpack and Babel for React components
- Improved Visual Builder rendering with proper React integration
- Enhanced real-time preview capabilities in Divi Builder

### 1.4.2
- Fixed method signature compatibility issue with Divi Builder
- Updated render_as_builder_data method to match parent class requirements
- Resolved fatal error in Divi modules

### 1.4.1
- Fixed React component rendering in Divi Visual Builder
- Improved Visual Builder compatibility for real-time editing
- Enhanced styling options in Divi modules

### 1.4.0
- Added CSS selector fixes for Divi modules
- Improved styling options for questions and answers

### 1.3.9
- Improved Divi Visual Builder rendering
- Added background colors and font styling options

### 1.3.8
- Fixed JavaScript issues in Divi integration
- Added proper localization for Divi modules

### 1.3.7
- Fixed Divi module rendering in Visual Builder
- Added placeholder content for Visual Builder

### 1.3.6
- Added Divi Builder integration
- Created custom Divi modules for FAQ display and search

### 1.3.5
- Removed "Add New FAQ" admin submenu item
- Streamlined admin interface

### 1.3.4
- Refactored search functionality to use in-page filtering
- Added query string support for sharing filtered results
- Added clear button to reset search

## Credits

Developed by makeWeb.

## License

This plugin is licensed under the GPL v2 or later.

---

For support or feature requests, please contact [makeWeb](https://makeweb.com).