<?php
/**
 * Fired during plugin activation.
 *
 * @link       https://makeweb.com
 * @since      1.0.0
 *
 * @package    Make_FAQ
 * @subpackage Make_FAQ/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Make_FAQ
 * @subpackage Make_FAQ/includes
 * @author     makeWeb
 */
class Make_FAQ_Activator {

    /**
     * Activate the plugin.
     *
     * Register custom post types and taxonomies on activation.
     * Flush rewrite rules to ensure proper URL handling.
     *
     * @since    1.0.0
     */
    public static function activate() {
        // Register the custom post type and taxonomies
        require_once MAKE_FAQ_PLUGIN_DIR . 'includes/class-make-faq-post-types.php';
        $post_types = new Make_FAQ_Post_Types();
        $post_types->register_post_types();
        $post_types->register_taxonomies();
        
        // Flush rewrite rules to ensure our custom post types work
        flush_rewrite_rules();
    }
}