<?php
/**
 * Fired during plugin deactivation.
 *
 * @link       https://makeweb.com
 * @since      1.0.0
 *
 * @package    Make_FAQ
 * @subpackage Make_FAQ/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Make_FAQ
 * @subpackage Make_FAQ/includes
 * @author     makeWeb
 */
class Make_FAQ_Deactivator {

    /**
     * Deactivate the plugin.
     *
     * Flush rewrite rules on deactivation to remove custom post type rules.
     *
     * @since    1.0.0
     */
    public static function deactivate() {
        // Flush rewrite rules to remove our custom post type rules
        flush_rewrite_rules();
    }
}