<?php
/**
 * Register custom post types and taxonomies.
 *
 * @link       https://makeweb.com
 * @since      1.0.0
 *
 * @package    Make_FAQ
 * @subpackage Make_FAQ/includes
 */

/**
 * Register custom post types and taxonomies.
 *
 * This class handles the registration of the FAQ custom post type
 * and its associated taxonomies (categories and tags).
 *
 * @since      1.0.0
 * @package    Make_FAQ
 * @subpackage Make_FAQ/includes
 * @author     makeWeb
 */
class Make_FAQ_Post_Types {

    /**
     * Register the FAQ custom post type.
     *
     * @since    1.0.0
     */
    public function register_post_types() {
        $labels = array(
            'name'                  => _x( 'FAQs', 'Post type general name', 'make-faq' ),
            'singular_name'         => _x( 'FAQ', 'Post type singular name', 'make-faq' ),
            'menu_name'             => _x( 'FAQs', 'Admin Menu text', 'make-faq' ),
            'name_admin_bar'        => _x( 'FAQ', 'Add New on Toolbar', 'make-faq' ),
            'add_new'               => __( 'Add New', 'make-faq' ),
            'add_new_item'          => __( 'Add New FAQ', 'make-faq' ),
            'new_item'              => __( 'New FAQ', 'make-faq' ),
            'edit_item'             => __( 'Edit FAQ', 'make-faq' ),
            'view_item'             => __( 'View FAQ', 'make-faq' ),
            'all_items'             => __( 'All FAQs', 'make-faq' ),
            'search_items'          => __( 'Search FAQs', 'make-faq' ),
            'parent_item_colon'     => __( 'Parent FAQs:', 'make-faq' ),
            'not_found'             => __( 'No FAQs found.', 'make-faq' ),
            'not_found_in_trash'    => __( 'No FAQs found in Trash.', 'make-faq' ),
            'featured_image'        => _x( 'FAQ Cover Image', 'Overrides the "Featured Image" phrase', 'make-faq' ),
            'set_featured_image'    => _x( 'Set cover image', 'Overrides the "Set featured image" phrase', 'make-faq' ),
            'remove_featured_image' => _x( 'Remove cover image', 'Overrides the "Remove featured image" phrase', 'make-faq' ),
            'use_featured_image'    => _x( 'Use as cover image', 'Overrides the "Use as featured image" phrase', 'make-faq' ),
            'archives'              => _x( 'FAQ archives', 'The post type archive label used in nav menus', 'make-faq' ),
            'insert_into_item'      => _x( 'Insert into FAQ', 'Overrides the "Insert into post" phrase', 'make-faq' ),
            'uploaded_to_this_item' => _x( 'Uploaded to this FAQ', 'Overrides the "Uploaded to this post" phrase', 'make-faq' ),
            'filter_items_list'     => _x( 'Filter FAQs list', 'Screen reader text for the filter links heading on the post type listing screen', 'make-faq' ),
            'items_list_navigation' => _x( 'FAQs list navigation', 'Screen reader text for the pagination heading on the post type listing screen', 'make-faq' ),
            'items_list'            => _x( 'FAQs list', 'Screen reader text for the items list heading on the post type listing screen', 'make-faq' ),
        );

        $args = array(
            'labels'             => $labels,
            'public'             => true,
            'publicly_queryable' => false, // Disable single page view
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'rewrite'            => array( 'slug' => 'faq' ),
            'capability_type'    => 'post',
            'has_archive'        => false, // Disable archive page
            'hierarchical'       => false,
            'menu_position'      => null,
            'menu_icon'          => 'dashicons-format-chat',
            'supports'           => array( 'title', 'editor', 'author', 'revisions' ),
            'show_in_rest'       => true,
        );

        register_post_type( 'make_faq', $args );
    }

    /**
     * Register taxonomies for the FAQ custom post type.
     *
     * @since    1.0.0
     */
    public function register_taxonomies() {
        // Register FAQ Category taxonomy
        $category_labels = array(
            'name'                       => _x( 'FAQ Categories', 'taxonomy general name', 'make-faq' ),
            'singular_name'              => _x( 'FAQ Category', 'taxonomy singular name', 'make-faq' ),
            'search_items'               => __( 'Search FAQ Categories', 'make-faq' ),
            'popular_items'              => __( 'Popular FAQ Categories', 'make-faq' ),
            'all_items'                  => __( 'All FAQ Categories', 'make-faq' ),
            'parent_item'                => __( 'Parent FAQ Category', 'make-faq' ),
            'parent_item_colon'          => __( 'Parent FAQ Category:', 'make-faq' ),
            'edit_item'                  => __( 'Edit FAQ Category', 'make-faq' ),
            'update_item'                => __( 'Update FAQ Category', 'make-faq' ),
            'add_new_item'               => __( 'Add New FAQ Category', 'make-faq' ),
            'new_item_name'              => __( 'New FAQ Category Name', 'make-faq' ),
            'separate_items_with_commas' => __( 'Separate FAQ categories with commas', 'make-faq' ),
            'add_or_remove_items'        => __( 'Add or remove FAQ categories', 'make-faq' ),
            'choose_from_most_used'      => __( 'Choose from the most used FAQ categories', 'make-faq' ),
            'not_found'                  => __( 'No FAQ categories found.', 'make-faq' ),
            'menu_name'                  => __( 'FAQ Categories', 'make-faq' ),
        );

        $category_args = array(
            'hierarchical'          => true,
            'labels'                => $category_labels,
            'show_ui'               => true,
            'show_admin_column'     => true,
            'query_var'             => true,
            'rewrite'               => array( 'slug' => 'faq-category' ),
            'show_in_rest'          => true,
        );

        register_taxonomy( 'faq_category', array( 'make_faq' ), $category_args );

        // Register FAQ Tag taxonomy
        $tag_labels = array(
            'name'                       => _x( 'FAQ Tags', 'taxonomy general name', 'make-faq' ),
            'singular_name'              => _x( 'FAQ Tag', 'taxonomy singular name', 'make-faq' ),
            'search_items'               => __( 'Search FAQ Tags', 'make-faq' ),
            'popular_items'              => __( 'Popular FAQ Tags', 'make-faq' ),
            'all_items'                  => __( 'All FAQ Tags', 'make-faq' ),
            'parent_item'                => null,
            'parent_item_colon'          => null,
            'edit_item'                  => __( 'Edit FAQ Tag', 'make-faq' ),
            'update_item'                => __( 'Update FAQ Tag', 'make-faq' ),
            'add_new_item'               => __( 'Add New FAQ Tag', 'make-faq' ),
            'new_item_name'              => __( 'New FAQ Tag Name', 'make-faq' ),
            'separate_items_with_commas' => __( 'Separate FAQ tags with commas', 'make-faq' ),
            'add_or_remove_items'        => __( 'Add or remove FAQ tags', 'make-faq' ),
            'choose_from_most_used'      => __( 'Choose from the most used FAQ tags', 'make-faq' ),
            'not_found'                  => __( 'No FAQ tags found.', 'make-faq' ),
            'menu_name'                  => __( 'FAQ Tags', 'make-faq' ),
        );

        $tag_args = array(
            'hierarchical'          => false,
            'labels'                => $tag_labels,
            'show_ui'               => true,
            'show_admin_column'     => true,
            'query_var'             => true,
            'rewrite'               => array( 'slug' => 'faq-tag' ),
            'show_in_rest'          => true,
        );

        register_taxonomy( 'faq_tag', array( 'make_faq' ), $tag_args );
    }
}