jQuery(function ($) {
  $.fn.searchable = function () {
	const $self = $(this);
	const $searchField = $self.find('[data-role="mw-search-input"]');
	const $glossaryItems = $self.find('[data-role="mw-item"]');
	const $hgSections = $self.find('[data-role="mw-section"]');
	const $hgNav = $self.find('[data-role="mw-nav-selectable"]');

	$searchField.on("input", function () {
	  const value = $(this).val().toLowerCase();

	  $hgSections.attr("data-has-filtered-items", false);
	  $hgNav.removeClass("htgb_active_nav");

	  $glossaryItems.each(function () {
		const $item = $(this);
		const itemText = $item.text().toLowerCase();
		const isVisible = itemText.includes(value);

		$item.toggle(isVisible);

		if (isVisible) {
		  $item.closest('[data-role="mw-section"]').attr("data-has-filtered-items", true);
		}
	  });

	  applySearchFilterFlag($self, $searchField);
	});
  };

  $.fn.navigable = function () {
	const $self = $(this);
	const $options = $self.find('[data-role="mw-nav-selectable"]');
	const $hgSections = $self.find('[data-role="mw-section"]');
	const $searchField = $self.find('[data-role="mw-search-input"]');

	$options.on('click', function () {
	  const $this = $(this);
	  $options.removeClass("htgb_active_nav");
	  $this.addClass("htgb_active_nav");

	  const targetLetter = $this.data("name").toLowerCase();
	  const isSearchApplied = $searchField.attr("data-is-search") === "true";

	  $hgSections.each(function () {
		const $section = $(this);
		const sectionLetter = $section.find('[data-role="mw-section-letter"]').text().toLowerCase();
		const showSection = targetLetter === "all" || sectionLetter === targetLetter;

		if (isSearchApplied) {
		  $section.toggle($section.attr("data-has-filtered-items") === "true");
		} else {
		  $section.toggle(showSection);
		}
	  });
	});
  };

  const applySectionFilters = function ($target) {
	$target.find('[data-role="mw-section"]').each(function () {
	  const $section = $(this);
	  const letter = $section.find('[data-role="mw-section-letter"]').text();
	  const hasFilteredItems = $section.attr("data-has-filtered-items") === "true";
	  const $navItem = $('[data-role="mw-nav-selectable"][data-name="' + letter + '"]');

	  $section.toggle(hasFilteredItems);
	  $navItem.toggleClass("htgb_search_disabled", !hasFilteredItems);
	});
  };

  const revertSectionFilters = function ($target) {
	$target.find('[data-role="mw-section"]').show();
	$('[data-role="mw-nav-selectable"]').removeClass("htgb_search_disabled");
  };

  const applySearchFilterFlag = function ($block, $searchField) {
	const value = $searchField.val().toLowerCase();
	const isSearch = value.length > 0;

	$searchField.attr("data-is-search", isSearch);

	if (isSearch) {
	  applySectionFilters($block);
	} else {
	  revertSectionFilters($block);
	}
  };

  // Initialize the navigation and search functionality
  const $containers = $(".mw-glossary");
  $containers.each(function () {
	$(this).navigable();
	$(this).searchable();
  });
});
