<?php
defined('ABSPATH') || exit;

// Add submenu page under Glossaries CPT
add_action('admin_menu', function () {
	add_submenu_page(
		'edit.php?post_type=glossaries', // Parent slug (CPT menu)
		'Glossary Shortcode Info',       // Page title
		'How to Use',                    // Menu title
		'manage_options',                // Capability
		'glossary-shortcode-info',      // Menu slug
		'mw_glossary_shortcode_info_page' // Callback function
	);
});

// Callback function to render the page
function mw_glossary_shortcode_info_page() {
	?>
	<div class="wrap">
		<h1>How to Use the Glossary Shortcode</h1>
		<p>You can embed the glossary anywhere on your site using the following shortcode:</p>
		<pre><code>[mw_glossary]</code></pre>

		<h2>Optional Parameters</h2>
		<p>The shortcode accepts the following parameters to customize the output:</p>

		<ul>
			<li>
				<code>show_empty</code> (default: <strong>true</strong>)<br>
				Whether to show letters in the glossary that have no items.<br>
				<strong>Example:</strong> <code>[mw_glossary show_empty="false"]</code>
			</li>
			<li>
				<code>search</code> (default: <strong>true</strong>)<br>
				Whether to display the search box at the top of the glossary.<br>
				<strong>Example:</strong> <code>[mw_glossary search="false"]</code>
			</li>
		</ul>

		<h3>Full Example</h3>
		<pre><code>[mw_glossary show_empty="false" search="false"]</code></pre>

		<h2>Notes</h2>
		<ul>
			<li>This shortcode displays glossary terms (from the <code>glossaries</code> post type), grouped by their starting letter.</li>
			<li>Output includes navigation by letter and optional search functionality.</li>
			<li>Only pages containing the shortcode will load the required CSS and JavaScript assets.</li>
		</ul>
	</div>
	<?php
}