<?php

add_action( 'acf/include_fields', function() {
	if ( ! function_exists( 'acf_add_local_field_group' ) ) {
		return;
	}

	acf_add_local_field_group( array(
	'key' => 'group_67ef4b65e69e6',
	'title' => 'Description',
	'fields' => array(
		array(
			'key' => 'field_67ef4b663c45e',
			'label' => 'Description',
			'name' => 'description',
			'aria-label' => '',
			'type' => 'wysiwyg',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'acfe_wysiwyg_height' => 300,
			'acfe_wysiwyg_max_height' => '',
			'acfe_wysiwyg_valid_elements' => '',
			'acfe_wysiwyg_custom_style' => '',
			'acfe_wysiwyg_disable_wp_style' => 0,
			'acfe_wysiwyg_autoresize' => 0,
			'acfe_wysiwyg_disable_resize' => 0,
			'acfe_wysiwyg_remove_path' => 0,
			'acfe_wysiwyg_menubar' => 0,
			'acfe_wysiwyg_transparent' => 0,
			'acfe_wysiwyg_merge_toolbar' => 0,
			'acfe_wysiwyg_custom_toolbar' => 0,
			'allow_in_bindings' => 0,
			'tabs' => 'visual',
			'toolbar' => 'basic',
			'media_upload' => 0,
			'delay' => 0,
			'acfe_wysiwyg_auto_init' => 0,
			'acfe_wysiwyg_min_height' => 300,
			'acfe_wysiwyg_toolbar_buttons' => array(
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'glossaries',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'left',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
	'acfe_autosync' => '',
	'acfe_form' => 0,
	'acfe_display_title' => '',
	'acfe_meta' => '',
	'acfe_note' => '',
) );
} );

add_action( 'init', function() {
	register_post_type( 'glossaries', array(
	'labels' => array(
		'name' => 'Glossary',
		'singular_name' => 'Glossaries',
		'menu_name' => 'Glossary',
		'all_items' => 'All Glossary',
		'edit_item' => 'Edit Glossaries',
		'view_item' => 'View Glossaries',
		'view_items' => 'View Glossary',
		'add_new_item' => 'Add New Glossaries',
		'add_new' => 'Add New Glossaries',
		'new_item' => 'New Glossaries',
		'parent_item_colon' => 'Parent Glossaries:',
		'search_items' => 'Search Glossary',
		'not_found' => 'No glossary found',
		'not_found_in_trash' => 'No glossary found in Trash',
		'archives' => 'Glossaries Archives',
		'attributes' => 'Glossaries Attributes',
		'insert_into_item' => 'Insert into glossaries',
		'uploaded_to_this_item' => 'Uploaded to this glossaries',
		'filter_items_list' => 'Filter glossary list',
		'filter_by_date' => 'Filter glossary by date',
		'items_list_navigation' => 'Glossary list navigation',
		'items_list' => 'Glossary list',
		'item_published' => 'Glossaries published.',
		'item_published_privately' => 'Glossaries published privately.',
		'item_reverted_to_draft' => 'Glossaries reverted to draft.',
		'item_scheduled' => 'Glossaries scheduled.',
		'item_updated' => 'Glossaries updated.',
		'item_link' => 'Glossaries Link',
		'item_link_description' => 'A link to a glossaries.',
	),
	'public' => true,
	'show_in_rest' => true,
	'menu_position' => 5,
	'menu_icon' => 'dashicons-book-alt',
	'supports' => array(
		0 => 'title',
		1 => 'custom-fields',
	),
	'delete_with_user' => false,
	) );
} );

// Admin columns: add Description excerpt column for Glossaries
add_filter('manage_glossaries_posts_columns', function($columns) {
	// Insert after title if possible
	$new = [];
	foreach ($columns as $key => $label) {
		$new[$key] = $label;
		if ($key === 'title') {
			$new['mw_desc_excerpt'] = __('Description', 'mw-glossary');
		}
	}
	if (!isset($new['mw_desc_excerpt'])) {
		$new['mw_desc_excerpt'] = __('Description', 'mw-glossary');
	}
	return $new;
});

add_action('manage_glossaries_posts_custom_column', function($column, $post_id) {
	if ($column === 'mw_desc_excerpt') {
		$desc = function_exists('get_field') ? (string) get_field('description', $post_id) : (string) get_post_meta($post_id, 'description', true);
		$text = trim(wp_strip_all_tags($desc));
		$len  = 120;
		if (function_exists('mb_substr')) {
			$excerpt = mb_substr($text, 0, $len);
			$more = (mb_strlen($text) > $len);
		} else {
			$excerpt = substr($text, 0, $len);
			$more = (strlen($text) > $len);
		}
		echo esc_html($excerpt . ($more ? '…' : ''));
	}
}, 10, 2);

