<?php
class MW_Glossary_Module extends ET_Builder_Module
{
	public function init()
	{
		$this->name    = 'MW Glossary';
		$this->slug    = 'mw_glossary_module';
		$this->vb_support = 'off';

		// Advanced design controls for Divi Builder
		$this->advanced_fields = [
			'fonts' => [
				'nav_links' => [
					'label' => __('Navigation Links', 'mw-glossary'),
					'css'   => ['main' => '%%order_class%% .mw-nav a'],
				],
				'letter' => [
					'label' => __('Letter Headings', 'mw-glossary'),
					'css'   => ['main' => '%%order_class%% .mw-content__letter'],
				],
				'item_title' => [
					'label' => __('Item Title', 'mw-glossary'),
					'css'   => ['main' => '%%order_class%% .mw-item-title'],
				],
				'item_description' => [
					'label' => __('Item Description', 'mw-glossary'),
					'css'   => ['main' => '%%order_class%% .mw-item-description'],
				],
				'search_input' => [
					'label' => __('Search Input', 'mw-glossary'),
					'css'   => ['main' => '%%order_class%% .mw-search input'],
				],
			],
			'background' => [
				'css' => ['main' => '%%order_class%% .mw-glossary'],
			],
			'borders' => [
				'default' => [
					'css' => ['main' => '%%order_class%% .mw-glossary'],
				],
			],
			'box_shadow' => [
				'default' => [
					'css' => ['main' => '%%order_class%% .mw-glossary'],
				],
			],
			'margin_padding' => [
				'css' => [
					'main' => '%%order_class%% .mw-glossary',
					'important' => 'all',
				],
			],
			'filters' => [
				'css' => [ 'main' => '%%order_class%% .mw-glossary' ],
			],
		];
	}

	public function get_fields()
	{
		return [
			'hide_search' => [
				'label'       => __('Hide Search', 'mw-glossary'),
				'type'        => 'yes_no_button',
				'options'     => [ 'off' => __('No', 'mw-glossary'), 'on' => __('Yes', 'mw-glossary') ],
				'tab_slug'    => 'general',
				'toggle_slug' => 'main_content',
				'description' => __('Hide the search input above the glossary.', 'mw-glossary'),
				'default'     => 'off',
			],
			'show_empty' => [
				'label'       => __('Show Empty Letters', 'mw-glossary'),
				'type'        => 'yes_no_button',
				'options'     => [ 'off' => __('No', 'mw-glossary'), 'on' => __('Yes', 'mw-glossary') ],
				'tab_slug'    => 'general',
				'toggle_slug' => 'main_content',
				'description' => __('Show letters that have no glossary items.', 'mw-glossary'),
				'default'     => 'off',
			],
		];
	}

	public function render($attrs, $content, $render_slug)
	{
		// Ensure the plugin's assets are loaded when used via Divi module
		if (wp_style_is('mw-glossary-style', 'registered') || wp_style_is('mw-glossary-style', 'enqueued')) {
			wp_enqueue_style('mw-glossary-style');
		}
		if (wp_script_is('mw-glossary-script', 'registered') || wp_script_is('mw-glossary-script', 'enqueued')) {
			wp_enqueue_script('mw-glossary-script');
		}

		$hide_search = isset($this->props['hide_search']) && $this->props['hide_search'] === 'on';
		$show_empty  = isset($this->props['show_empty']) && $this->props['show_empty'] === 'on';
		$shortcode = sprintf('[mw_glossary search="%s" show_empty="%s"]', $hide_search ? 'false' : 'true', $show_empty ? 'true' : 'false');

		// Render the existing shortcode so there is a single source of truth
		return do_shortcode($shortcode);
	}
}

new MW_Glossary_Module();
