<?php
/**
 * Plugin Name: MW Glossary
 * Description: A glossary shortcode for non-Divi sites.
 * Version: 1.0.33
 * Author: makeweb
 */

defined('ABSPATH') || exit;

// Composer autoloader (if present)
$__mw_glossary_autoload = __DIR__ . '/vendor/autoload.php';
if (file_exists($__mw_glossary_autoload)) {
	require_once $__mw_glossary_autoload;
}

// Include CPT and ACF fields
require_once plugin_dir_path(__FILE__) . 'includes/glossary-post-type.php';
require_once plugin_dir_path(__FILE__) . 'includes/glossary-options-page.php';
require_once plugin_dir_path(__FILE__) . 'includes/glossary-import-export.php';

// Load Divi module/init from within the plugin folder
$mw_divi_init = __DIR__ . '/init.php';
if (file_exists($mw_divi_init)) {
	include_once $mw_divi_init;
}

// Register shortcode
add_shortcode('mw_glossary', 'mw_glossary_shortcode');

// Register but don't enqueue assets yet
add_action('wp_enqueue_scripts', function () {
	$plugin_url = plugin_dir_url(__FILE__);
	wp_register_style('mw-glossary-style', $plugin_url . 'assets/Glossary.css', [], '1.0.0');
	wp_register_script('mw-glossary-script', $plugin_url . 'assets/Glossary.js', ['jquery'], '1.0.0', true);
});

// Check if shortcode is present in queried posts
add_filter('the_posts', function ($posts) {
	if (empty($posts)) return $posts;

	foreach ($posts as $post) {
		if (has_shortcode($post->post_content, 'mw_glossary')) {
			add_action('wp_enqueue_scripts', function () {
				wp_enqueue_style('mw-glossary-style');
				wp_enqueue_script('mw-glossary-script');
			});
			break;
		}
	}

	return $posts;
});

function mw_glossary_shortcode($atts = [], $content = null) {
	// Accept shortcode attributes: search (true/false), show_empty (true/false)
	$atts = shortcode_atts([
		'search' => 'true',
		'show_empty' => 'true',
	], $atts, 'mw_glossary');
	$bool = function($v) {
		$v = strtolower(trim((string)$v));
		return !in_array($v, ['0','false','off','no',''], true);
	};
	$show_search = $bool($atts['search']);
	$show_empty  = $bool($atts['show_empty']);

	$args = [
		'post_type' => 'glossaries',
		'posts_per_page' => -1,
		'orderby' => 'title',
		'order' => 'ASC'
	];
	$query = new WP_Query($args);
	$glossary_items = [];
	$all_letters = range('A', 'Z');
	$used_letters = [];

	if ($query->have_posts()) {
		while ($query->have_posts()) {
			$query->the_post();
			$title = get_the_title();
			$description = function_exists('get_field') ? get_field('description') : get_post_meta(get_the_ID(), 'description', true);
			$first_letter = strtoupper($title[0]);

			if (!isset($glossary_items[$first_letter])) {
				$glossary_items[$first_letter] = [];
			}

			$glossary_items[$first_letter][] = [
				'title' => $title,
				'description' => $description,
			];

			if (!in_array($first_letter, $used_letters)) {
				$used_letters[] = $first_letter;
			}
		}
		wp_reset_postdata();
	}

	$nav_links = '<a class="htgb_active_nav" data-role="mw-nav-selectable" href="#all" data-name="all">All</a>';
	foreach ($all_letters as $letter) {
		if ($show_empty || in_array($letter, $used_letters)) {
			$nav_links .= sprintf('<a href="#%1$s" data-name="%1$s" data-role="mw-nav-selectable">%1$s</a>', $letter);
		}
	}

	$content_html = '';
	foreach ($all_letters as $letter) {
		if (!$show_empty && !isset($glossary_items[$letter])) {
			continue;
		}
		$content_html .= '<div class="mw-letter-section" data-role="mw-section" id="letter-' . $letter . '">';
		$content_html .= sprintf('<span class="mw-content__letter" data-role="mw-section-letter">%s</span>', $letter);

		if (isset($glossary_items[$letter])) {
			foreach ($glossary_items[$letter] as $item) {
				$content_html .= '<dl class="mw-item" data-role="mw-item">';
				$content_html .= sprintf('<dt class="mw-item-title" data-role="mw-item-title">%s</dt>', esc_html($item['title']));
				$content_html .= sprintf('<dd class="mw-item-description" data-role="mw-item-description">%s</dd>', wp_kses_post($item['description']));
				$content_html .= '</dl>';
			}
		}

		$content_html .= '</div>';
	}

	$search_html = $show_search ? '<div class="mw-search"><input type="text" data-role="mw-search-input" placeholder="Search the Glossary..."></div>' : '';

	return sprintf(
		'<div class="mw-glossary is-style-default">
			<div class="mw-glossary__header">
				%1$s
				<div class="mw-nav">%2$s</div>
			</div>
			<div class="mw-content">%3$s</div>
		</div>',
		$search_html,
		$nav_links,
		$content_html
	);
}

////////////////////////// UPDATES //////////////////////////
// ID, Key, __File__
$updater = new makeUpdate( "9540", "419050",  __FILE__);