# Make Testimonials (CPT + Shortcodes + Divi)

A beginner-friendly WordPress plugin by MakeWeb that adds a Testimonials custom post type with categories, simple custom fields, and separate Grid and Slider shortcodes plus Divi modules.

Author: MakeWeb (https://makeweb.com.au)

## Features
- Testimonials custom post type (no single view)
- Categories taxonomy for testimonials
- Beginner-friendly fields: Testimonial Text (simple editor), Person’s Name, Role/Company, Rating, Photo, Website, Featured (list toggle)
- Separate shortcodes for Grid and Slider with styling options
- Optional Divi Builder modules (Grid and Slider) auto-register if Divi is active

## Installation
1. Copy the `make-testimonials` folder into your WordPress `wp-content/plugins/` directory.
2. In WordPress Admin → Plugins, activate “Make Testimonials (CPT + Shortcodes + Divi)”.
3. Add testimonials under Testimonials → Add New. Assign categories as needed.

## Custom Post Type
- Menu: Testimonials
- Supports: Title (auto-generated, title field hidden). The testimonial text is entered via a simple field in the Details metabox.
- No single pages are publicly viewable (they 404); use the shortcodes/modules to display them.

## Custom Fields (Metabox)
- Person’s Name
- Role / Company
- Rating (0–5)
- Photo (media library)
- Website (optional)
- Featured (checkbox)

## Shortcodes
Use the dedicated shortcodes for each layout style.

### Grid
Shortcode: `[testimonials_grid]`

Attributes:
- category: category slug(s), comma-separated
- limit: number of testimonials (default: `12`)
- target_width: CSS size per card (default: `360px`) — grid auto-fits columns based on available space
- grid_style: `standard|equal|masonry` (default: `standard`)
- show_rating: `true|false` (default: `true`)
- show_photo: `true|false` (default: `true`)
- gap: CSS size for gap between cards (default: `16px`)
- card_bg: CSS color for card background (default: `#ffffff`)
- text_color: CSS color for text (default: `#222222`)
- accent_color: CSS color for stars (default: `#ffb400`)
- border_width: CSS size for the blockquote accent border (default: `0`) — e.g. `3px`
- orderby: WP_Query orderby (default: `date`)
- order: `ASC|DESC` (default: `DESC`)

Examples:
- Responsive grid targeting ~360px cards:
  [testimonials_grid]
- Masonry grid with ~300px cards:
  [testimonials_grid grid_style="masonry" target_width="300px" category="clients"]
- Grid with 3px accent border on the bubble:
  [testimonials_grid border_width="3px" accent_color="#c36"]

### Slider
Shortcode: `[testimonials_slider]`

Attributes:
- category: category slug(s), comma-separated
- limit: number of testimonials (default: `12`)
- show_rating: `true|false` (default: `true`)
- show_photo: `true|false` (default: `true`)
- autoplay: milliseconds (default: `4000`, set `0` to disable)
- arrows: `true|false` (default: `true`)
- dots: `true|false` (default: `true`)
- gap: CSS size for gap between cards (default: `16px`)
- card_bg: CSS color for card background (default: `#ffffff`)
- text_color: CSS color for text (default: `#222222`)
- accent_color: CSS color for stars (default: `#ffb400`)
- border_width: CSS size for the blockquote accent border (default: `0`) — e.g. `3px`
- orderby: WP_Query orderby (default: `date`)
- order: `ASC|DESC` (default: `DESC`)

Examples:
- Basic slider with autoplay:
  [testimonials_slider autoplay="3000" arrows="true" dots="true"]

### Backwards compatibility
The legacy `[testimonials]` shortcode still works and accepts `display="grid|slider"`, but using the dedicated shortcodes above is recommended for more specific customisation.

## Divi Modules
If you use Divi Builder, two modules are added automatically:
- “Testimonials Grid” — matches `[testimonials_grid]` options
- “Testimonials Slider” — matches `[testimonials_slider]` options

## Notes
- Assets (CSS/JS) are loaded only on pages where the shortcodes/modules are used.
- Testimonials are excluded from search and single pages are disabled by design.

## Uninstall
Simply deactivate and delete the plugin. No tables are created. Post data remains in the database.
