(function(){
  function setBorderVar(el){
    if(!el) return;
    var cs = getComputedStyle(el);
    var bw = cs.borderBottomWidth || '0px';
    // Normalize to px number
    var n = parseFloat(bw);
    if(isNaN(n)) n = 0;
    el.style.setProperty('--wpt-border-width', n + 'px');
  }
  function init(root){
    var bubbles = (root || document).querySelectorAll('.wpt-bubble');
    bubbles.forEach(function(b){ setBorderVar(b); });
    // Observe size changes of each bubble to recompute border var
    if (window.ResizeObserver) {
      var ro = new ResizeObserver(function(entries){
        entries.forEach(function(entry){ setBorderVar(entry.target); });
      });
      bubbles.forEach(function(b){ ro.observe(b); });
    }
  }
  document.addEventListener('DOMContentLoaded', function(){
    init(document);
    // Also update on window resize to be safe
    var t;
    window.addEventListener('resize', function(){
      clearTimeout(t);
      t = setTimeout(function(){ init(document); }, 120);
    });
  });
})();
