(function(){
  function toPx(val, context){
    if(!val) return 360;
    if(typeof val === 'number') return val;
    val = (''+val).trim();
    if(val.endsWith('px')) return parseFloat(val) || 0;
    if(val.endsWith('rem')) {
      var fs = parseFloat(getComputedStyle(document.documentElement).fontSize) || 16;
      return (parseFloat(val) || 0) * fs;
    }
    if(val.endsWith('%')) {
      var pct = parseFloat(val) || 0;
      var base = (context && context.clientWidth) ? context.clientWidth : (window.innerWidth||1000);
      return base * pct/100;
    }
    // bare number assumed px
    var n = parseFloat(val);
    return isNaN(n) ? 360 : n;
  }

  function initMasonry(root){
    var items = root.querySelector('.wpt-items');
    if(!items) return;

    function computeCount(){
      var rootStyle = getComputedStyle(root);
      var gapVar = rootStyle.getPropertyValue('--wpt-gap').trim() || '16px';
      var targetVar = rootStyle.getPropertyValue('--wpt-target').trim() || '360px';
      var itemsStyle = getComputedStyle(items);
      var pl = toPx(itemsStyle.paddingLeft || '0', items);
      var pr = toPx(itemsStyle.paddingRight || '0', items);
      // Use the inner content width (clientWidth - paddings)
      var containerWidth = Math.max(0, items.clientWidth - pl - pr);
      var gap = toPx(gapVar, root);
      var target = toPx(targetVar, root);
      if (target <= 0) target = 360;
      // Account for bubble border and padding widths to avoid overestimating columns
      var extra = 0;
      var sample = root.querySelector('.wpt-item .wpt-bubble, .wpt-slide .wpt-bubble, .wpt-bubble');
      if (sample) {
        var cs = getComputedStyle(sample);
        var bl = parseFloat(cs.borderLeftWidth) || 0;
        var br = parseFloat(cs.borderRightWidth) || 0;
        var plb = parseFloat(cs.paddingLeft) || 0;
        var prb = parseFloat(cs.paddingRight) || 0;
        extra = bl + br + plb + prb;
      }
      var effective = target + extra;
      var count = Math.floor((containerWidth + gap) / (effective + gap));
      if (count < 1) count = 1;
      return count;
    }

    function layout(){
      var count = computeCount();
      items.style.columnCount = String(count);
      items.style.columnGap = getComputedStyle(root).getPropertyValue('--wpt-gap') || '16px';
    }

    var ro = null;
    if (window.ResizeObserver) {
      ro = new ResizeObserver(function(){ layout(); });
      ro.observe(root);
    }

    var resizeTimer;
    window.addEventListener('resize', function(){
      clearTimeout(resizeTimer);
      resizeTimer = setTimeout(layout, 150);
    });

    // initial
    layout();
  }

  document.addEventListener('DOMContentLoaded', function(){
    document.querySelectorAll('.wpt-wrap.wpt-grid[data-grid-style="masonry"]').forEach(initMasonry);
  });
})();
