(function(){
  function initSlider(root){
    var items = root.querySelector('.wpt-items');
    if(!items) return;
    var slides = Array.prototype.slice.call(items.querySelectorAll('.wpt-slide'));
    var idx = 0;
    var autoplay = parseInt(root.getAttribute('data-autoplay'),10)||0;
    var arrowsMode = root.getAttribute('data-arrows') || 'show'; // 'hide' | 'show' | 'hover'
    var showArrows = arrowsMode !== 'hide';
    var dots = root.getAttribute('data-dots')==='1';

    // layout helper (recompute gap and snap to current index without animation)
    function layout(snapSmooth){
      items.style.display = 'flex';
      items.style.gap = '0';
      var gap = getComputedStyle(root).getPropertyValue('--wpt-gap') || '16px';
      slides.forEach(function(el){
        el.style.minWidth = '100%';
        el.style.paddingInline = 'calc((' + gap + ')/2)';
        el.style.boxSizing = 'border-box';
      });
      // snap to current index
      var left = items.clientWidth * idx;
      try {
        items.scrollTo({ left: left, behavior: snapSmooth ? 'smooth' : 'auto' });
      } catch(e) {
        items.scrollLeft = left;
      }
    }

    function updateDots(){
      if(!dots) return;
      var buttons = root.querySelectorAll('.wpt-dots button');
      buttons.forEach(function(b){ b.classList.remove('active'); });
      if(buttons[idx]) buttons[idx].classList.add('active');
    }

    function go(i){
      idx = (i+slides.length)%slides.length;
      layout(true);
      updateDots();
    }

    if(showArrows){
      var prev = root.querySelector('.wpt-prev');
      var next = root.querySelector('.wpt-next');
      if(prev) prev.addEventListener('click', function(){ go(idx-1); });
      if(next) next.addEventListener('click', function(){ go(idx+1); });
    }

    if(dots){
      var dotsWrap = root.querySelector('.wpt-dots');
      slides.forEach(function(_,i){
        var b=document.createElement('button');
        b.addEventListener('click', function(){ go(i); });
        dotsWrap.appendChild(b);
      });
    }

    var timer;
    function start(){ if(autoplay>0){ stop(); timer=setInterval(function(){ go(idx+1); }, autoplay); } }
    function stop(){ if(timer){ clearInterval(timer); timer=null; } }

    root.addEventListener('mouseenter', stop);
    root.addEventListener('mouseleave', start);

    // Resize handling: do not wait for next slide; snap after 100ms of no resize
    var resizeDebounce;
    window.addEventListener('resize', function(){
      stop();
      layout(false); // immediate correction without animation during resize
      clearTimeout(resizeDebounce);
      resizeDebounce = setTimeout(function(){ layout(false); updateDots(); start(); }, 120);
    });

    // initial render
    layout(false);
    updateDots();
    start();
  }

  document.addEventListener('DOMContentLoaded', function(){
    document.querySelectorAll('.wpt-wrap.wpt-slider').forEach(initSlider);
  });
})();
