<?php
if (!defined('ABSPATH')) { exit; }

if (class_exists('ET_Builder_Module')) {
    if (!class_exists('WPT_Divi_Testimonials_Grid_Module')) {
        class WPT_Divi_Testimonials_Grid_Module extends ET_Builder_Module {
            public $slug       = 'wpt_testimonials_grid';
            function init() { $this->name = esc_html__('Testimonials Grid', 'wp-testimonials'); }
            function get_fields() {
                return [
                    'category' => [ 'label' => __('Category Slugs', 'wp-testimonials'), 'type' => 'text' ],
                    'limit' => [ 'label' => __('Number to show', 'wp-testimonials'), 'type' => 'text', 'default' => '12' ],
                    'show_rating' => [ 'label' => __('Show rating', 'wp-testimonials'), 'type' => 'yes_no_button', 'options' => ['on'=>'Yes','off'=>'No'], 'default' => 'on'],
                    'show_photo' => [ 'label' => __('Show photo', 'wp-testimonials'), 'type' => 'yes_no_button', 'options' => ['on'=>'Yes','off'=>'No'], 'default' => 'on'],
                    'gap' => [ 'label' => __('Gap', 'wp-testimonials'), 'type' => 'text', 'default' => '16px' ],
                    'card_bg' => [ 'label' => __('Card background', 'wp-testimonials'), 'type' => 'color-alpha', 'default' => '#ffffff' ],
                    'text_color' => [ 'label' => __('Text color', 'wp-testimonials'), 'type' => 'color-alpha', 'default' => '#222222' ],
                    'accent_color' => [ 'label' => __('Accent color', 'wp-testimonials'), 'type' => 'color-alpha', 'default' => '#ffb400' ],
                ];
            }
            function render($attrs, $content = null, $render_slug = '') {
                $atts = [
                    'category' => $this->props['category'],
                    'limit' => $this->props['limit'],
                    'show_rating' => $this->props['show_rating'] === 'on' ? 'true':'false',
                    'show_photo' => $this->props['show_photo'] === 'on' ? 'true':'false',
                    'gap' => $this->props['gap'],
                    'card_bg' => $this->props['card_bg'],
                    'text_color' => $this->props['text_color'],
                    'accent_color' => $this->props['accent_color'],
                ];
                return do_shortcode('[testimonials_grid ' . http_build_query($atts, '', ' ') . ']');
            }
        }

    }

    if (!class_exists('WPT_Divi_Testimonials_Slider_Module')) {
        class WPT_Divi_Testimonials_Slider_Module extends ET_Builder_Module {
            public $slug       = 'wpt_testimonials_slider';
            function init() { $this->name = esc_html__('Testimonials Slider', 'wp-testimonials'); }
            function get_fields() {
                return [
                    'category' => [ 'label' => __('Category Slugs', 'wp-testimonials'), 'type' => 'text' ],
                    'limit' => [ 'label' => __('Number to show', 'wp-testimonials'), 'type' => 'text', 'default' => '12' ],
                    'show_rating' => [ 'label' => __('Show rating', 'wp-testimonials'), 'type' => 'yes_no_button', 'options' => ['on'=>'Yes','off'=>'No'], 'default' => 'on'],
                    'show_photo' => [ 'label' => __('Show photo', 'wp-testimonials'), 'type' => 'yes_no_button', 'options' => ['on'=>'Yes','off'=>'No'], 'default' => 'on'],
                    'autoplay' => [ 'label' => __('Autoplay (ms)', 'wp-testimonials'), 'type' => 'text', 'default' => '4000' ],
                    'arrows' => [ 'label' => __('Arrows', 'wp-testimonials'), 'type' => 'select', 'options' => ['hide'=>__('Hide','wp-testimonials'),'show'=>__('Show','wp-testimonials'),'hover'=>__('Show on hover','wp-testimonials')], 'default' => 'show' ],
                    'dots' => [ 'label' => __('Show dots', 'wp-testimonials'), 'type' => 'yes_no_button', 'options' => ['on'=>'Yes','off'=>'No'], 'default' => 'on'],
                    'gap' => [ 'label' => __('Gap', 'wp-testimonials'), 'type' => 'text', 'default' => '16px' ],
                    'card_bg' => [ 'label' => __('Card background', 'wp-testimonials'), 'type' => 'color-alpha', 'default' => '#ffffff' ],
                    'text_color' => [ 'label' => __('Text color', 'wp-testimonials'), 'type' => 'color-alpha', 'default' => '#222222' ],
                    'accent_color' => [ 'label' => __('Accent color', 'wp-testimonials'), 'type' => 'color-alpha', 'default' => '#ffb400' ],
                ];
            }
            function render($attrs, $content = null, $render_slug = '') {
                $atts = [
                    'category' => $this->props['category'],
                    'limit' => $this->props['limit'],
                    'show_rating' => $this->props['show_rating'] === 'on' ? 'true':'false',
                    'show_photo' => $this->props['show_photo'] === 'on' ? 'true':'false',
                    'autoplay' => $this->props['autoplay'],
                    'arrows' => $this->props['arrows'] ?: 'show',
                    'dots' => $this->props['dots'] === 'on' ? 'true':'false',
                    'gap' => $this->props['gap'],
                    'card_bg' => $this->props['card_bg'],
                    'text_color' => $this->props['text_color'],
                    'accent_color' => $this->props['accent_color'],
                ];
                return do_shortcode('[testimonials_slider ' . http_build_query($atts, '', ' ') . ']');
            }
        }
    }
}
