<?php
if (!defined('ABSPATH')) { exit; }

// Load only when Divi builder module base is available
if (!class_exists('ET_Builder_Module')) {
    return;
}

if (!class_exists('WPT_Divi_Testimonials_Grid_Module')) {
    class WPT_Divi_Testimonials_Grid_Module extends ET_Builder_Module {
        public $slug       = 'wpt_testimonials_grid';

        function init() { 
            $this->name = esc_html__('Testimonials Grid', 'wp-testimonials');
            $this->main_css_element = '%%order_class%%';
        }

        public function get_advanced_fields_config() {
            return [
                'fonts' => [
                    // Testimonial text (blockquote)
                    'testimonial_text' => [
                        'label' => __('Testimonial Text', 'wp-testimonials'),
                        'css'   => [ 'main' => $this->main_css_element . ' .wpt-bubble' ],
                        'line_height' => [ 'default' => '1.6em' ],
                        'text_align'  => [ 'options' => [] ],
                    ],
                    // Name
                    'name' => [
                        'label' => __('Name', 'wp-testimonials'),
                        'css'   => [ 'main' => $this->main_css_element . ' .wpt-name' ],
                        'font_size' => [ 'default' => '18px' ],
                        'line_height' => [ 'default' => '1.3em' ],
                    ],
                    // Role/company
                    'role' => [
                        'label' => __('Role / Company', 'wp-testimonials'),
                        'css'   => [ 'main' => $this->main_css_element . ' .wpt-role' ],
                        'font_size' => [ 'default' => '14px' ],
                        'line_height' => [ 'default' => '1.4em' ],
                    ],
                    // Website text
                    'website' => [
                        'label' => __('Website', 'wp-testimonials'),
                        'css'   => [ 'main' => $this->main_css_element . ' .wpt-site, ' . $this->main_css_element . ' .wpt-site a' ],
                        'font_size' => [ 'default' => '14px' ],
                    ],
                    // Stars
                    'stars' => [
                        'label' => __('Stars', 'wp-testimonials'),
                        'css'   => [ 'main' => $this->main_css_element . ' .wpt-stars' ],
                        'font_size' => [ 'default' => '14px' ],
                    ],
                ],
                'background' => [
                    'use_background_color' => true,
                    'css' => [ 'main' => $this->main_css_element . ' .wpt-bubble' ],
                ],
                'borders' => [
                    'default' => [
                        'label_prefix' => __('Bubble', 'wp-testimonials') . ' ',
                        'css' => [
                            'main' => [
                                'border_radii'  => $this->main_css_element . ' .wpt-bubble',
                                'border_styles' => $this->main_css_element . ' .wpt-bubble',
                            ],
                            'important' => 'all',
                        ],
                    ],
                ],
                'box_shadow' => [
                    'default' => [
                        'label' => __('Bubble Box Shadow', 'wp-testimonials'),
                        'css' => [ 'main' => $this->main_css_element . ' .wpt-bubble' ],
                    ],
                ],
                'margin_padding' => [
                    'css' => [ 'main' => $this->main_css_element . ' .wpt-bubble'],
                ],
            ];
        }

        function get_fields() {
            return [
                'category' => [ 'label' => __('Category Slugs', 'wp-testimonials'), 'type' => 'text' ],
                'limit' => [ 'label' => __('Number to show', 'wp-testimonials'), 'type' => 'text', 'default' => '12' ],
                'target_width' => [ 'label' => __('Card target width (CSS size)', 'wp-testimonials'), 'type' => 'text', 'default' => '360px' ],
                'grid_style' => [ 'label' => __('Grid style', 'wp-testimonials'), 'type' => 'select', 'options' => [ 'standard'=>__('Standard','wp-testimonials'), 'equal'=>__('Equal heights','wp-testimonials'), 'masonry'=>__('Masonry','wp-testimonials') ], 'default' => 'standard' ],
                'show_rating' => [ 'label' => __('Show rating', 'wp-testimonials'), 'type' => 'yes_no_button', 'options' => ['on'=>'Yes','off'=>'No'], 'default' => 'on'],
                'show_photo' => [ 'label' => __('Show photo', 'wp-testimonials'), 'type' => 'yes_no_button', 'options' => ['on'=>'Yes','off'=>'No'], 'default' => 'on'],
                'gap' => [ 'label' => __('Gap', 'wp-testimonials'), 'type' => 'text', 'default' => '16px' ],
                'bubble' => [ 'label' => __('Speech bubble tail', 'wp-testimonials'), 'type' => 'select', 'options' => [ 'none'=>__('None','wp-testimonials'), 'bottom-left'=>__('Bottom left','wp-testimonials'), 'bottom-center'=>__('Bottom center','wp-testimonials'), 'bottom-right'=>__('Bottom right','wp-testimonials') ], 'default' => 'bottom-left' ],
            ];
        }

        function render($attrs, $content = null, $render_slug = '') {
            $atts = [
                'category' => $this->props['category'],
                'limit' => $this->props['limit'],
                'target_width' => $this->props['target_width'] ?: '360px',
                'show_rating' => $this->props['show_rating'] === 'on' ? 'true':'false',
                'show_photo' => $this->props['show_photo'] === 'on' ? 'true':'false',
                'gap' => $this->props['gap'],
                'bubble' => $this->props['bubble'] ?: 'bottom-left',
                'grid_style' => $this->props['grid_style'] ?: 'standard',
                'design_source' => 'divi',
            ];
            $inner = function_exists('wpt_render_testimonials_grid')
                ? wpt_render_testimonials_grid($atts)
                : do_shortcode('[testimonials_grid ' . http_build_query($atts, '', ' ') . ']');
            // Build Divi module classes properly
            $classes = $this->module_classname( $render_slug ) . ' wpt-divi-module wpt-divi-grid';
            return sprintf('<div class="%s" data-module="wpt_testimonials_grid">%s</div>', esc_attr($classes), $inner);
        }
    }
}

// Instantiate the module so Divi registers it
if (class_exists('WPT_Divi_Testimonials_Grid_Module')) {
    new WPT_Divi_Testimonials_Grid_Module();
}
