<?php
if (!defined('ABSPATH')) { exit; }

// Load only when Divi builder module base is available
if (!class_exists('ET_Builder_Module')) {
    return;
}

if (!class_exists('WPT_Divi_Testimonials_Slider_Module')) {
    class WPT_Divi_Testimonials_Slider_Module extends ET_Builder_Module {
        public $slug       = 'wpt_testimonials_slider';

        function init() { 
            $this->name = esc_html__('Testimonials Slider', 'wp-testimonials'); 
            $this->main_css_element = '%%order_class%%';
        }

        public function get_advanced_fields_config() {
            return [
                'fonts' => [
                    'testimonial_text' => [
                        'label' => __('Testimonial Text', 'wp-testimonials'),
                        'css'   => [ 'main' => $this->main_css_element . ' .wpt-bubble' ],
                        'line_height' => [ 'default' => '1.6em' ],
                        'text_align'  => [ 'options' => [] ],
                    ],
                    'name' => [
                        'label' => __('Name', 'wp-testimonials'),
                        'css'   => [ 'main' => $this->main_css_element . ' .wpt-name' ],
                        'font_size' => [ 'default' => '18px' ],
                        'line_height' => [ 'default' => '1.3em' ],
                    ],
                    'role' => [
                        'label' => __('Role / Company', 'wp-testimonials'),
                        'css'   => [ 'main' => $this->main_css_element . ' .wpt-role' ],
                        'font_size' => [ 'default' => '14px' ],
                        'line_height' => [ 'default' => '1.4em' ],
                    ],
                    'website' => [
                        'label' => __('Website', 'wp-testimonials'),
                        'css'   => [ 'main' => $this->main_css_element . ' .wpt-site, ' . $this->main_css_element . ' .wpt-site a' ],
                        'font_size' => [ 'default' => '14px' ],
                    ],
                    'stars' => [
                        'label' => __('Stars', 'wp-testimonials'),
                        'css'   => [ 'main' => $this->main_css_element . ' .wpt-stars' ],
                        'font_size' => [ 'default' => '14px' ],
                    ],
                ],
                'background' => [
                    'use_background_color' => true,
                    'css' => [ 'main' => $this->main_css_element . ' .wpt-bubble' ],
                ],
                'borders' => [
                    'default' => [
                        'label_prefix' => __('Bubble', 'wp-testimonials') . ' ',
                        'css' => [
                            'main' => [
                                'border_radii'  => $this->main_css_element . ' .wpt-bubble',
                                'border_styles' => $this->main_css_element . ' .wpt-bubble',
                            ],
                        ],
                        'important' => 'all',
                    ],
                ],
                'box_shadow' => [
                    'default' => [
                        'label' => __('Bubble Box Shadow', 'wp-testimonials'),
                        'css' => [ 'main' => $this->main_css_element . ' .wpt-bubble' ],
                    ],
                ],
                'margin_padding' => [
                    'css' => [ 'main' => $this->main_css_element . ' .wpt-bubble' ],
                ],
            ];
        }

        function get_fields() {
            return [
                'category' => [ 'label' => __('Category Slugs', 'wp-testimonials'), 'type' => 'text' ],
                'limit' => [ 'label' => __('Number to show', 'wp-testimonials'), 'type' => 'text', 'default' => '12' ],
                'show_rating' => [ 'label' => __('Show rating', 'wp-testimonials'), 'type' => 'yes_no_button', 'options' => ['on'=>'Yes','off'=>'No'], 'default' => 'on'],
                'show_photo' => [ 'label' => __('Show photo', 'wp-testimonials'), 'type' => 'yes_no_button', 'options' => ['on'=>'Yes','off'=>'No'], 'default' => 'on'],
                'autoplay' => [ 'label' => __('Autoplay (ms)', 'wp-testimonials'), 'type' => 'text', 'default' => '4000' ],
                'arrows' => [ 'label' => __('Arrows', 'wp-testimonials'), 'type' => 'select', 'options' => ['hide'=>__('Hide','wp-testimonials'),'show'=>__('Show','wp-testimonials'),'hover'=>__('Show on hover','wp-testimonials')], 'default' => 'show'],
                'dots' => [ 'label' => __('Show dots', 'wp-testimonials'), 'type' => 'yes_no_button', 'options' => ['on'=>'Yes','off'=>'No'], 'default' => 'on'],
                'gap' => [ 'label' => __('Gap', 'wp-testimonials'), 'type' => 'text', 'default' => '16px' ],
                'bubble' => [ 'label' => __('Speech bubble tail', 'wp-testimonials'), 'type' => 'select', 'options' => [ 'none'=>__('None','wp-testimonials'), 'bottom-left'=>__('Bottom left','wp-testimonials'), 'bottom-center'=>__('Bottom center','wp-testimonials'), 'bottom-right'=>__('Bottom right','wp-testimonials') ], 'default' => 'bottom-left' ],
                'card_max_width' => [ 'label' => __('Card max width (CSS size)', 'wp-testimonials'), 'type' => 'text', 'default' => '1440px' ],
            ];
        }

        function render($attrs, $content = null, $render_slug = '') {
            $atts = [
                'category' => $this->props['category'],
                'limit' => $this->props['limit'],
                'show_rating' => $this->props['show_rating'] === 'on' ? 'true':'false',
                'show_photo' => $this->props['show_photo'] === 'on' ? 'true':'false',
                'autoplay' => $this->props['autoplay'],
                'arrows' => $this->props['arrows'] ?: 'show',
                'dots' => $this->props['dots'] === 'on' ? 'true':'false',
                'gap' => $this->props['gap'],
                'bubble' => $this->props['bubble'] ?: 'bottom-left',
                'card_max_width' => $this->props['card_max_width'] ?: '1440px',
                'design_source' => 'divi',
            ];
            $inner = function_exists('wpt_render_testimonials_slider')
                ? wpt_render_testimonials_slider($atts)
                : do_shortcode('[testimonials_slider ' . http_build_query($atts, '', ' ') . ']');
            // Build Divi module classes properly
            $classes = $this->module_classname( $render_slug ) . ' wpt-divi-module wpt-divi-slider';
            return sprintf('<div class="%s" data-module="wpt_testimonials_slider">%s</div>', esc_attr($classes), $inner);
        }
    }
}

// Instantiate the module so Divi registers it
if (class_exists('WPT_Divi_Testimonials_Slider_Module')) {
    new WPT_Divi_Testimonials_Slider_Module();
}
