<?php

namespace Optimus\Divi\Modules\AppleTVTile;

use Optimus\Divi\Modules\BaseModule as DiviModule;
use ET_Builder_Element;

class Module extends DiviModule
{
    public $name = 'Apple TV Tile';

    protected $adminIconBackgroundSize = '40px';

    protected $adminIconBackgroundPositionX = '10px';

    protected $adminIconBackgroundPositionY = '17px';

    public function init()
    {
        parent::init();

        $this->advanced_fields = [
            'fonts' => [
                'header' => [
                    'label' => esc_html__('Header', 'et_builder'),
                    'css' => [
                        'main' => "{$this->main_css_element} h2.project__title, {$this->main_css_element} h2.project__title a",
                        'important' => 'all',
                    ],
                    'line_height' => [
                        'range_settings' => [
                            'min' => '1',
                            'max' => '100',
                            'step' => '0.1',
                        ],
                    ],
                ],
            ],
        ];
    }

    public function fields()
    {
        return [
            'title' => [
                'label' => 'Title',
                'type' => 'text',
            ],
            'bg_img' => [
                'label' => esc_html__('Image URL', 'et_builder'),
                'type' => 'upload',
                'option_category' => 'basic_option',
                'upload_button_text' => esc_attr__('Upload an image', 'et_builder'),
                'choose_text' => esc_attr__('Choose an Image', 'et_builder'),
                'update_text' => esc_attr__('Set As Image', 'et_builder'),
                'description' => esc_html__(
                    'Upload your desired image, or type in the URL to the image you would like to display.',
                    'et_builder'
                ),
            ],
            'url' => [
                'label' => esc_html__('Link URL', 'et_builder'),
                'type' => 'text',
                'affects' => [
                    'use_overlay',
                ],
                'description' => esc_html__(
                    'If you would like your image to be a link, input your destination URL here. No link will be created if this field is left blank.',
                    'et_builder'
                ),
            ],
            'disabled_on' => [
                'label' => __('Disable on', 'et_builder'),
                'type' => 'multiple_checkboxes',
                'options' => [
                    'phone' => __('Phone', 'et_builder'),
                    'tablet' => __('Tablet', 'et_builder'),
                    'desktop' => __('Desktop', 'et_builder'),
                ],
                'additional_att' => 'disable_on',
                'option_category' => 'configuration',
                'description' => __('This will disable the module on selected devices', 'et_builder'),
            ],
            'admin_label' => [
                'label' => __('Admin Label', 'et_builder'),
                'type' => 'text',
                'description' => __(
                    'This will change the label of the module in the builder for easy identification.',
                    'et_builder'
                ),
            ],
            'module_id' => [
                'label' => __('CSS ID', 'et_builder'),
                'type' => 'text',
                'option_category' => 'configuration',
                'tab_slug' => 'custom_css',
                'option_class' => 'et_pb_custom_css_regular',
            ],
            'module_class' => [
                'label' => __('CSS Class', 'et_builder'),
                'type' => 'text',
                'option_category' => 'configuration',
                'tab_slug' => 'custom_css',
                'option_class' => 'et_pb_custom_css_regular',
            ],
        ];
    }

    public function render($atts, $content, $function_name)
    {
        $module_id = $this->props['module_id'];
        $module_class = $this->props['module_class'];
        $title = $this->props['title'];
        $bg_img = $this->props['bg_img'];
        $url = $this->props['url'];

        $module_class = ET_Builder_Element::add_module_order_class($module_class, $function_name);

        $script = sprintf('jQuery(document).ready(function(){
            jQuery(".project").hover3d({
                selector: ".project__card",
                shine: false,
                sensitivity: 30,
                invert: true,
            });
        });');

        $output = sprintf(
            '<div %1$s class="project %2$s wrap">
                <div class="project__card">
                    <a href="%6$s" class="project__image" > <img %5$s> </a>
                    <div class="project__detail">
                        <h2 class="project__title">
                            <a href="#">%4$s</a>
                        </h2>
                    </div>
                </div>
            </div>',
            ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
            ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : ''),
            ('' !== $bg_img ? sprintf('background-image: url(%1$s);', $bg_img) : ''),
            $title,
            ('' !== $bg_img ? sprintf('src="%1$s";', $bg_img) : ''),
            $url
        );

        if (!is_admin()) {
            wp_enqueue_script('atvhover', $this->assetUrl('jquery.hover3d.min.js'));
            wp_add_inline_script('atvhover', $script);
            wp_enqueue_style('atvstyle', $this->assetUrl('appletv.css'));
        }

        return $output;
    }
}
