<?php

namespace Optimus\Divi\Modules;

use ET_Builder_Module;

abstract class BaseModule extends ET_Builder_Module
{
    protected $advancedOptions = [];

    protected $customCSSOptions = [];

    protected $path;

    public function __construct($path)
    {
        $this->path = $path;
        $this->version = 1;

        parent::__construct();
    }

    public function init()
    {

        if ('' == $this->slug) {
            $this->slug = $this->slugify($this->name);
        }

        $this->fields_defaults = [];
        $this->main_css_element = '%%order_class%%.' . $this->slug;
        $this->advanced_fields = $this->getAdvancedOptions();
        $this->custom_css_fields = $this->getCustomCSSOptions();
    }

    public function fields()
    {
        return [];
    }

    public function get_fields()
    {
        return $this->fields();
    }

    public function shortcode_callback($atts, $content, $function_name)
    {
    }

    protected function slugify($name)
    {
        if ($this->version == 2) {
            return str_replace('-', '_', sanitize_title($name));
        }
        return 'et_pb_' . str_replace('-', '_', sanitize_title($name));
    }

    protected function getAdvancedOptions()
    {
        if (method_exists($this, 'advancedOptions')) {
            return $this->advancedOptions();
        }

        return $this->advancedOptions;
    }

    protected function getCustomCSSOptions()
    {
        return $this->customCSSOptions;
    }

    public function getUrl($path)
    {
        if (function_exists('plugin_dir_url')) {
            return plugin_dir_url($path);
        }

        return str_replace(
            str_replace('/wp-content/themes', '', get_theme_root()),
            get_site_url(),
            str_replace(['/', '\\'], DIRECTORY_SEPARATOR, $path)
        );
    }

    public function getPath()
    {
        return $this->path;
    }

    public function getDirectoryPath()
    {
        return dirname($this->getPath());
    }

    public function assetUrl($asset)
    {
        return $this->getUrl($this->path) . $this->relativeAssetPath($asset);
    }

    public function relativeAssetPath($asset)
    {
        // This needs to be updated for the new structure
        $class = get_class($this);
        $parts = explode('\\', $class);
        $moduleName = $parts[count($parts) - 2];
        return 'includes/Modules/' . $moduleName . '/assets/' . $asset;
    }

    public function assetPath($asset)
    {
        return $this->getDirectoryPath() . '/' . $this->relativeAssetPath($asset);
    }

    public function packageName()
    {
        if ($this->version == 2) {
            return sanitize_title($this->name);
        }
        return 'optimus-divi-' . sanitize_title($this->name) . '-module';
    }

    public function get_image_alt_text($image_url)
    {
        if (!$image_url) {
            return '';
        }
        if ('/' === $image_url[0])
            $post_id = attachment_url_to_postid(home_url() . $image_url);
        else
            $post_id = attachment_url_to_postid($image_url);

        $alt_text = get_post_meta($post_id, '_wp_attachment_image_alt', TRUE);
        if ('' === $alt_text)
            $alt_text = get_the_title($post_id);

        return $alt_text;
    }

}
