<?php

namespace Optimus\Divi\Modules\BeforeAndAfter;

use Optimus\Divi\Modules\BaseModule as DiviModule;
use ET_Builder_Element;

class Module extends DiviModule
{
    const DEFAULT_SLIDER_POSITION = 50;

    public $name = 'Before And After';

    protected $adminIconLeftPadding = '15px';

    public function fields()
    {
        return [
            'before_image' => [
                'label' => 'Before Image URL',
                'type' => 'upload',
                'option_category' => 'basic_option',
                'upload_button_text' => 'Upload an image',
                'choose_text' => 'Choose an Image',
                'update_text' => 'Set As Image',
                'description' => 'Upload your desired image, or type in the URL to the image you would like to display.',
            ],
            'before_image_label' => [
                'label' => 'Before Image Label',
                'type' => 'text',
            ],
            'after_image' => [
                'label' => 'After Image URL',
                'type' => 'upload',
                'option_category' => 'basic_option',
                'upload_button_text' => 'Upload an image',
                'choose_text' => 'Choose an Image',
                'update_text' => 'Set As Image',
                'description' => 'Upload your desired image, or type in the URL to the image you would like to display.',
            ],
            'after_image_label' => [
                'label' => 'Before Image Label',
                'type' => 'text',
            ],

            'slide_pos' => [
                'label' => __('Slider Position', 'et_builder'),
                'type' => 'range',
                'default' => self::DEFAULT_SLIDER_POSITION,
                'range_settings' => [
                    'min' => 1,
                    'max' => 100,
                    'step' => 1,
                ],
            ],

            'direction' => [
                'label' => __('Slide Direction', 'et_builder'),
                'type' => 'select',
                'option_category' => 'configuration',
                'options' => [
                    'horizontal' => __('Horizontal', 'et_builder'),
                    'vertical' => __('Vertical', 'et_builder'),
                ],
            ],

            'overlay' => [
                'label' => __('Overlay Labels', 'et_builder'),
                'type' => 'select',
                'option_category' => 'configuration',
                'options' => [
                    'true' => __('Hide', 'et_builder'),
                    'false' => __('Show', 'et_builder'),
                ],
            ],

            'return' => [
                'label' => __('Return to default', 'et_builder'),
                'type' => 'select',
                'option_category' => 'configuration',
                'options' => [
                    'false' => __('No', 'et_builder'),
                    'true' => __('Yes', 'et_builder'),
                ],
            ],

            'admin_label' => [
                'label' => __('Admin Label', 'et_builder'),
                'type' => 'text',
                'description' => __('This will change the label of the module in the builder for easy identification.', 'et_builder'),
            ],
            'module_id' => [
                'label' => __('CSS ID', 'et_builder'),
                'type' => 'text',
                'option_category' => 'configuration',
                'description' => __('Enter an optional CSS ID to be used for this module. An ID can be used to create custom CSS styling, or to create links to particular sections of your page.', 'et_builder'),
            ],
            'module_class' => [
                'label' => __('CSS Class', 'et_builder'),
                'type' => 'text',
                'option_category' => 'configuration',
                'description' => __('Enter optional CSS classes to be used for this module. A CSS class can be used to create custom CSS styling. You can add multiple classes, separated with a space.', 'et_builder'),
            ],
        ];
    }

    public function shortcode_callback($atts, $content, $function_name)
    {
        $module_id = $this->shortcode_atts['module_id'];
        $module_class = $this->shortcode_atts['module_class'];
        $module_class = ET_Builder_Element::add_module_order_class($module_class, $function_name);
        $before_image_output = $this->shortcode_atts['before_image'];
        $after_image_output = $this->shortcode_atts['after_image'];
        $before_image_label = $this->shortcode_atts['before_image_label'];
        $after_image_label = $this->shortcode_atts['after_image_label'];
        $slide_pos = empty($this->shortcode_atts['slide_pos']) ? self::DEFAULT_SLIDER_POSITION : $this->shortcode_atts['slide_pos'];
        $slide_pos = (float) $slide_pos / 100.0;
        $direction = $this->shortcode_atts['direction'];
        $overlay = $this->shortcode_atts['overlay'];
        $return = $this->shortcode_atts['return'];

        $output = sprintf(
            '<div %1$s class="ba-slider %2$s" %5$s %6$s %7$s %8$s %9$s %10$s>
                <img src="%3$s" /> <img src="%4$s" />
            </div>',
            ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
            ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : ''),
            $after_image_output,
            $before_image_output,
            ('' !== $before_image_label ? sprintf('data-ba-before_label="%1$s"', esc_attr($before_image_label)) : ''),
            ('' !== $after_image_label ? sprintf('data-ba-after_label="%1$s"', esc_attr($after_image_label)) : ''),
            ('' !== $slide_pos ? sprintf('data-ba-default_offset_pct="%1$s"', esc_attr($slide_pos)) : ''),
            ('' !== $direction ? sprintf('data-ba-orientation="%1$s"', esc_attr($direction)) : ''),
            ('0' !== $overlay ? sprintf('data-ba-no_overlay="%1$s"', esc_attr($overlay)) : 'data-ba-no_overlay=true'),
            ('' !== $return ? sprintf('data-ba-return_on_mouseout="%1$s"', esc_attr($return)) : '')
        );

        if (!is_admin()) {
            wp_enqueue_script('jquery_event_move', $this->assetUrl('jquery.event.move.js'), ['jquery']);
            wp_enqueue_script('jquery_html5data', $this->assetUrl('jquery.html5data.min.js'), ['jquery']);
            wp_enqueue_script('jquery_twentytwenty', $this->assetUrl('jquery.twentytwenty.js'), ['jquery', 'jquery_html5data', 'jquery_event_move']);
            wp_enqueue_style('optimus-divi-before-and-after-style', $this->assetUrl('beforeandafter.css'));
        } else { /* any admin specific stuff */
        }

        return $output;
    }
}
