<?php

    namespace Optimus\Divi\Modules\BoxedList;

    use Optimus\Divi\Modules\BaseModule as DiviModule;
    use ET_Builder_Element;

    class Item extends DiviModule
    {
        public $name = 'Boxed List Item';

        public function init()
        {
            $this->type = 'child';
            $this->child_title_var = 'title';
            $this->advanced_setting_title_text = 'List Item';
            $this->settings_text = 'List Item Settings';

            parent::init();
        }

        public function fields()
        {
            return [
                'title' => [
                    'label' => 'Text',
                    'type' => 'text',
                ],
                'link' => [
                    'label' => 'URL',
                    'type' => 'text',
                    'description' => 'Here you can define the url (optional).',
                ],
            ];
        }

        public function shortcode_callback($atts, $content, $function_name)
        {
            $title = $this->shortcode_atts['title'];
            $link = $this->shortcode_atts['link'];

            return sprintf(
                '<div class="item">%2$s %1$s %3$s</div>',
                $title,
                ('' !== $link ? sprintf('<a href="%1$s">', $link) : ''),
                ('' !== $link ? '</a>' : '')
            );
        }
    }
