<?php

namespace Optimus\Divi\Modules\BoxedList;

use Optimus\Divi\Modules\BaseModule as DiviModule;
use ET_Builder_Element;

class Module extends DiviModule
{
    public $name = 'Boxed List';

    public function init()
    {
        $this->child_slug = $this->slugify('Boxed List Item');
        $this->child_item_text = 'List Item';

        $this->advanced_fields = [
            'fonts' => [
                'header' => [
                    'label' => esc_html__('Items', 'et_builder'),
                    'css' => [
                        'main' => "{$this->main_css_element} .item, {$this->main_css_element} .item a",
                    ],
                    'line_height' => [
                        'default' => '1em',
                    ],
                    'font_size' => [
                        'default' => '16px',
                    ],
                    'letter_spacing' => [
                        'default' => '0',
                    ],
                ],
            ],
            'background' => [
                'use_background_image' => false,
                'settings' => [
                    'color' => 'alpha',
                ],
                'css' => [
                    'main' => "{$this->main_css_element} .item",
                ],
            ],
        ];

        parent::init();
    }

    public function fields()
    {
        return [
            'disabled_on' => [
                'label' => __('Disable on', 'et_builder'),
                'type' => 'multiple_checkboxes',
                'options' => [
                    'phone' => __('Phone', 'et_builder'),
                    'tablet' => __('Tablet', 'et_builder'),
                    'desktop' => __('Desktop', 'et_builder'),
                ],
                'additional_att' => 'disable_on',
                'option_category' => 'configuration',
                'description' => __('This will disable the module on selected devices', 'et_builder'),
            ],
            'admin_label' => [
                'label' => __('Admin Label', 'et_builder'),
                'type' => 'text',
                'description' => __(
                    'This will change the label of the module in the builder for easy identification.',
                    'et_builder'
                ),
            ],
            'module_id' => [
                'label' => __('CSS ID', 'et_builder'),
                'type' => 'text',
                'option_category' => 'configuration',
                'tab_slug' => 'custom_css',
                'option_class' => 'et_pb_custom_css_regular',
            ],
            'module_class' => [
                'label' => __('CSS Class', 'et_builder'),
                'type' => 'text',
                'option_category' => 'configuration',
                'tab_slug' => 'custom_css',
                'option_class' => 'et_pb_custom_css_regular',
            ],
        ];
    }

    public function shortcode_callback($atts, $content, $function_name)
    {
        $module_id = $this->shortcode_atts['module_id'];
        $module_class = $this->shortcode_atts['module_class'];
        $module_class = ET_Builder_Element::add_module_order_class($module_class, $function_name);
        $breadcrumbs = $this->shortcode_content;

        $output = sprintf(
            '<div class="et_pb_mw_boxedist%3$s et_pb_module  clearfix" %2$s>
                %1$s
                <div class="item empty"></div>
                <div class="item empty"></div>
                <div class="item empty"></div>
            </div>',
            $breadcrumbs,
            ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
            ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : '')
        );

        if (!is_admin()) {
            wp_enqueue_style('boxedlist', $this->assetUrl('/assets/boxedlist.css'));
        }

        return $output;
    }
}
