<?php

namespace Optimus\Divi\Modules\BuyNow;

use ET_Builder_Element;
use Optimus\Divi\Modules\BaseModule as DiviModule;

class Module extends DiviModule
{
    public $name = 'Buy Now';

    protected $advancedOptions = [
        'button' => [
            'button' => [
                'label' => 'Button',
            ],
        ],
    ];

    public function fields()
    {
        return [
            'button_text' => [
                'label' => 'Button Text',
                'type' => 'text',
                'option_category' => 'basic_option',
                'description' => 'Input your desired button text.',
            ],
            'hosted_button_id' => [
                'label' => 'Hosted Button Id',
                'type' => 'text',
                'option_category' => 'basic_option',
                'description' => 'Your need to setup a button at <a href="https://www.paypal.com/buttonfactory/" target="_blank">https://www.paypal.com/buttonfactory/</a>',
            ],
            'text_orientation' => [
                'label' => 'Align',
                'type' => 'select',
                'option_category' => 'layout',
                'options' => et_builder_get_text_orientation_options(),
                'description' => 'This will adjust the alignment of the button',
            ],
            'admin_label' => [
                'label' => __('Admin Label', 'et_builder'),
                'type' => 'text',
                'description' => __('This will change the label of the module in the builder for easy identification.', 'et_builder'),
            ],
            'module_id' => [
                'label' => __('CSS ID', 'et_builder'),
                'type' => 'text',
                'option_category' => 'configuration',
                'description' => __('Enter an optional CSS ID to be used for this module. An ID can be used to create custom CSS styling, or to create links to particular sections of your page.', 'et_builder'),
            ],
            'module_class' => [
                'label' => __('CSS Class', 'et_builder'),
                'type' => 'text',
                'option_category' => 'configuration',
                'description' => __('Enter optional CSS classes to be used for this module. A CSS class can be used to create custom CSS styling. You can add multiple classes, separated with a space.', 'et_builder'),
            ],
        ];
    }

    public function shortcode_callback($atts, $content, $function_name)
    {
        $module_id = $this->shortcode_atts['module_id'];
        $module_class = $this->shortcode_atts['module_class'];
        $module_class = ET_Builder_Element::add_module_order_class($module_class, $function_name);
        $button_text = $this->shortcode_atts['button_text'];
        $text_orientation = $this->shortcode_atts['text_orientation'];
        $hosted_button_id = $this->shortcode_atts['hosted_button_id'];

        $output = sprintf(
            '<div%1$s class="et_pb_buy_now %2$s %4$s">
                <form target="paypal" action="https://www.paypal.com/cgi-bin/webscr" method="post">
                    <input type="hidden" name="cmd" value="_s-xclick">
                    <input type="hidden" name="hosted_button_id" value="%5$s">
                    <button type="submit" class="et_pb_button pointer">%3$s</button>
                    <img alt="" border="0" src="https://www.paypalobjects.com/en_US/i/scr/pixel.gif" width="1" height="1">
                </form>
            </div>',
            ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
            ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : ''),
            $button_text,
            ('et_pb_text_align_'.$text_orientation),
            $hosted_button_id
        );

        wp_enqueue_style('buynow', $this->assetUrl('buynow.css'));

        return $output;
    }
}
