<?php

namespace Optimus\Divi\Modules\CalderaForms;

use Optimus\Divi\Modules\BaseModule as DiviModule;
use ET_Builder_Element;

class Module extends DiviModule
{
    public $name = 'Caldera Forms';

    public function init()
    {
        parent::init();
    }
    
    public function advancedOptions()
    {
	return [
		'button' => [
                'button' => [
                    'label' => esc_html__('Button', 'et_builder'),
                    'css'   => [
                        'main' => "{$this->main_css_element} .et_pb_button",
                    ],
                ],
            ],
	];	
	}
	
    public function fields()
    {
        return [
            'form_id'      => [
                'label'           => esc_html__('Pick a form', 'et_builder'),
                'type'            => 'select',
                'option_category' => 'layout',
                'options'         => $this->getCalderaForms(),
                'description'     => 'This will chose which form to display. 
                    <a href="admin.php?page=caldera-forms" target="_blank">you can create forms here</a>.',
            ],
            'style'        => [
                'label'           => esc_html__('Add Styles', 'et_builder'),
                'type'            => 'select',
                'option_category' => 'configuration',
                'options'         => [
                    'light' => esc_html__('Light', 'et_builder'),
                    'dark'  => esc_html__('Dark', 'et_builder'),
                    'off'   => esc_html__('No Styles', 'et_builder'),
                ],
            ],
            'select'       => [
                'label'           => esc_html__('This Form uses select boxes', 'et_builder'),
                'type'            => 'yes_no_button',
                'option_category' => 'layout',
                'options'         => [
                    'off' => esc_html__('No', 'et_builder'),
                    'on'  => esc_html__('Yes', 'et_builder'),
                ],
            ],
            'modal'        => [
                'label'           => esc_html__('This Form opens as a modal', 'et_builder'),
                'type'            => 'yes_no_button',
                'option_category' => 'layout',
                'options'         => [
                    'off' => esc_html__('No', 'et_builder'),
                    'on'  => esc_html__('Yes', 'et_builder'),
                ],
            ],
            'modal_text'   => [
                'label'       => 'Modal Button Text',
                'type'        => 'text',
                'description' => __('This will only show it this for is a modal is on', 'et_builder'),
            ],
            'button_pos'   => [
                'label'    => esc_html__('Button Position', 'et_builder'),
                'type'     => 'select',
                'tab_slug' => 'advanced',
                'options'  => [
                    'right' => esc_html__('Right', 'et_builder'),
                    'left'  => esc_html__('Left', 'et_builder'),
                ],
            ],
            'disabled_on'  => [
                'label'           => __('Disable on', 'et_builder'),
                'type'            => 'multiple_checkboxes',
                'options'         => [
                    'phone'   => __('Phone', 'et_builder'),
                    'tablet'  => __('Tablet', 'et_builder'),
                    'desktop' => __('Desktop', 'et_builder'),
                ],
                'additional_att'  => 'disable_on',
                'option_category' => 'configuration',
                'description'     => __('This will disable the module on selected devices', 'et_builder'),
            ],
            'admin_label'  => [
                'label'       => __('Admin Label', 'et_builder'),
                'type'        => 'text',
                'description' => __('This will change the label of the module in the builder for easy identification.',
                    'et_builder'),
            ],
            'module_id'    => [
                'label'           => __('CSS ID', 'et_builder'),
                'type'            => 'text',
                'option_category' => 'configuration',
                'tab_slug'        => 'custom_css',
                'option_class'    => 'et_pb_custom_css_regular',
            ],
            'module_class' => [
                'label'           => __('CSS Class', 'et_builder'),
                'type'            => 'text',
                'option_category' => 'configuration',
                'tab_slug'        => 'custom_css',
                'option_class'    => 'et_pb_custom_css_regular',
            ],
        ];
    }

    public function shortcode_callback($atts, $content, $function_name)
    {
        $module_id    = $this->shortcode_atts['module_id'];
        $module_class = $this->shortcode_atts['module_class'];
        $form_id      = $this->shortcode_atts['form_id'];
        $style        = $this->shortcode_atts['style'];
        $select       = $this->shortcode_atts['select'];
        $modal        = $this->shortcode_atts['modal'];
        $modal_text   = $this->shortcode_atts['modal_text'];
        $button_pos   = $this->shortcode_atts['button_pos'];
        
        if('on' !== $modal){
	        $form = do_shortcode("[caldera_form id='$form_id']" . $modal_text . "[/caldera_form]");
        }else{
	        $form = do_shortcode("[caldera_form_modal id='$form_id' type='button' width='800']" . $modal_text . "[/caldera_form_modal]");
	        var_dump(class_exists('Caldera_Forms_Render_Modals'));
        }

        $module_class = ET_Builder_Element::add_module_order_class($module_class, $function_name);

        // Default Styles
        ET_Builder_Element::set_style($function_name, [
            'selector'    => '%%order_class%% .et_pb_contact_submit',
            'declaration' => "float: $button_pos;",
        ]);

        $output = sprintf(
            '<div %2$s class="et_pb_mw_calderaForm et_pb_caldera_forms et_pb_module %3$s %4$s clearfix">
				%1$s
			</div>',
            $form,
            ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
            ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : ''),
            ('' !== $style ? sprintf(' form_%1$s', esc_attr($style)) : '')
        );

        $url = $this->getUrl(__DIR__);

        if (is_admin()) {
            wp_enqueue_script('clearforms', $url . '/assets/nols.js');
        } else {
            wp_enqueue_script('butfix', $url . '/assets/caldera-butfix.js', ['jquery']);

            if ($select === 'on') {
                wp_enqueue_script('nice-select', $url . '/assets/jquery.nice-select.min.js', ['jquery']);
                wp_enqueue_style('caldera-niceselect', $url . '/assets/caldera-niceselect.css');
            }

            if ($style !== 'off') {
                wp_enqueue_style("cform_{$style}_divi", "$url/assets/cform_{$style}_divi.css");
            }
        }

        return $output;
    }

    private function getCalderaForms()
    {
        if (function_exists('et_builder_get_caldera_forms')) {
            return et_builder_get_caldera_forms();
        }

        if (! class_exists('Caldera_Forms')) {
            return [null => 'You need Caldera Forms plugin installed!'];
        }

        $forms = \Caldera_Forms::get_forms();

        if (empty($forms)) {
            return [null => 'Sorry, no caldera forms found. Make some first and return.'];
        }

        $options = [];
        foreach ($forms as $form_id => $form) {
            $options += [$form_id => esc_html__($form['name'], 'et_builder')];
        }

        return $options;
    }
}
