<?php

    namespace Optimus\Divi\Modules\ConditionalRedirect;

    use Optimus\Divi\Modules\BaseModule as DiviModule;
    use ET_Builder_Element;

    class Condition extends DiviModule
    {
        public $name = 'Condition';

        public function init()
        {
            $this->type = 'child';
            $this->child_title_var = 'condition';
            $this->advanced_setting_title_text = 'Condition';
            $this->settings_text = 'Condition Settings';

            parent::init();
        }

        public function get_fields()
        {
            return [

                'condition' => [
                    'label' => esc_html__('Condition', 'et_builder'),
                    'type' => 'select',
                    'option_category' => 'configuration',
                    'options' => [
                        'is_user_logged_in' => "User logged in",
                        'is_super_admin' => "Super Admin",
                    ],
                ],
            ];
        }

        public function render($atts, $content, $render_slug)
        {
            $condition = $this->props['condition'];

            $tf = call_user_func($condition);

            if(!isset($tf)){
                $tf = '0';
            }elseif ($tf == 1){
                $tf = '1';
            }else{
                $tf = '0';
            }

            return $tf;
        }
    }

