<?php

    namespace Optimus\Divi\Modules\ConditionalRedirect;

    use Optimus\Divi\Modules\BaseModule as DiviModule;
    use ET_Builder_Element;

    class Module extends DiviModule
    {
        public $name = 'Conditional Redirect';

        public function init()
        {
            $this->child_slug = $this->slugify('Condition');
            $this->child_item_text = 'Condition';
            parent::init();
        }

        public function get_fields()
        {
            return [

                'operator' => [
                    'label' => esc_html__('When * Conditions are met', 'et_builder'),
                    'type' => 'select',
                    'option_category' => 'configuration',
                    'options' => [
                        'all' => esc_html__('All', 'et_builder'),
                        'any' => esc_html__('Any', 'et_builder'),
                        'none' => esc_html__('None', 'et_builder'),
                    ],
                ],
                'redirect_url' => [
                    'label' => 'Redirect URL',
                    'type' => 'text',
                ],
                'admin_label' => [
                    'label' => 'Admin Label',
                    'type' => 'text',
                    'description' => __(
                        'This will change the label of the module in the builder for easy identification.',
                        'et_builder'
                    ),
                ],
            ];
        }

        public function render($atts, $content, $render_slug)
        {
            if(is_admin()){
                return;
            }
            $operator = $this->props['operator'];
            $redirect_url = $this->props['redirect_url'];
            $conditions = $this->content;

            $redirect = false;

            if($operator == 'all'){
                if (strpos($conditions, '0') !== false) {
                    return;
                }else{
                    $redirect = true;
                }
            }elseif($operator == 'any'){
                if (strpos($conditions, '1') !== true) {
                    return;
                }else{
                    $redirect = true;
                }

            }elseif($operator == 'none'){
                if (strpos($conditions, '1') !== false) {
                    return;
                }else{
                    $redirect = true;
                }
            }

            if($redirect) {
                echo "<script>window.location='$redirect_url'</script>";
                exit;
            }
        }
    }
