<?php

    namespace Optimus\Divi\Modules\EmbededGoogleMap;

    use Optimus\Divi\Modules\BaseModule as DiviModule;
    use ET_Builder_Element;

    class Module extends DiviModule
    {
        public $name = 'Embeded Google Map';

        public function init()
        {
            $this->version = 2;
            $this->slug = 'embeded-google-map';
            parent::init();
        }

        public function getCustomCSSOptions()
        {
            $custom_css_fields = [];
            return $custom_css_fields;
        }

        public function get_advanced_fields_config()
        {
            $advanced_fields = [];
            $advanced_fields['border'] = [];
            $advanced_fields['animation'] = [];
            $advanced_fields['margin_padding'] = [
                'css' => [
                    'padding' => "{$this->main_css_element}",
                    'margin' => "{$this->main_css_element}",
                ],

            ];
            $advanced_fields['background'] = [
                'css' => array(
                    'main' => "{$this->main_css_element}",
                ),
            ];
            return $advanced_fields;
        }

        public function get_fields()
        {
            return [
                'address' => [
                    'label' => __('Address on Business name', 'et_builder'),
                    'type' => 'text',
                ],
                'suburb' => [
                    'label' => __('Suburb', 'et_builder'),
                    'type' => 'text',
                ],
                'state' => [
                    'label' => __('State', 'et_builder'),
                    'type' => 'text',
                    'default_on_front'=> 'NSW',
                ],
                'country' => [
                    'label' => __('Country', 'et_builder'),
                    'type' => 'text',
                    'default_on_front'=> 'Australia',
                ],
                'zoom' => array(
                    'label'           => 'Map Zoom',
                    'type'            => 'range',
                    'mobile_options'  => false,
                    'validate_unit'   => false,
                    'default'         => '15',
                    'default_unit'    => '',
                    'default_on_front' => '15',
                    'range_settings'  => array(
                        'min'  => '0',
                        'max'  => '20',
                        'step' => '1',
                    ),
                ),
                'height' => array(
                    'label'           => 'Map Height px',
                    'type'            => 'range',
                    'mobile_options'  => false,
                    'validate_unit'   => false,
                    'default'         => '500',
                    'default_unit'    => '',
                    'default_on_front' => '500',
                    'range_settings'  => array(
                        'min'  => '0',
                        'max'  => '1000',
                        'step' => '10',
                    ),
                ),
                'module_id' => [
                    'label' => __('CSS ID', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'tab_slug' => 'custom_css',
                    'option_class' => 'et_pb_custom_css_regular',
                ],
                'module_class' => [
                    'label' => __('CSS Class', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'tab_slug' => 'custom_css',
                    'option_class' => 'et_pb_custom_css_regular',
                ],
            ];
        }

        public function render($atts, $content, $render_slug)
        {
            $module_id = $this->props['module_id'];
            $module_class = $this->props['module_class'];
            $module_class = trim(ET_Builder_Element::add_module_order_class($module_class, $render_slug));
            $address = $this->props['address'];
            $suburb = $this->props['suburb'];
            $state = $this->props['state'];
            $country = $this->props['country'];
            $zoom = $this->props['zoom'];
            $height = $this->props['height'];

            $output = sprintf(
                '<div %1$s class="%2$s %3$s">
                <iframe class="embeded_map" height="%9$s" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="http://maps.google.com/maps?q=%4$s %5$s %6$s %7$s&layer=tc&t=m&z=%8$s&source=embed&output=svembed"></iframe>
                </div>',
                ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
                ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : ''),
                $this->slug,
                ('' !== $address ? sprintf(' %1$s,', esc_attr($address)) : ''),
                ('' !== $suburb ? sprintf(' %1$s,', esc_attr($suburb)) : ''),
                ('' !== $state ? sprintf(' %1$s,', esc_attr($state)) : ''),
                ('' !== $country ? $country : ''),
                ('' !== $zoom ? $zoom : '15'),
                ('' !== $height ? $height : '500')
            );

//            wp_enqueue_script($this->slug, $path = $this->assetUrl('script.js'));
            wp_enqueue_style($this->slug, $this->assetUrl('style.css'));

            return $output;
        }
    }
