<?php

    namespace Optimus\Divi\Modules\FlickityGallerySlider;

    use Optimus\Divi\Modules\BaseModule as DiviModule;
    use ET_Builder_Element;

    class Module extends DiviModule
    {
        public $name = 'Flickity Gallery Slider';

        public function init()
        {
            $this->fullwidth = FALSE;
            $this->slug = 'flickity-gallery-slider';
            parent::init();
        }

        public function getCustomCSSOptions()
        {
            $custom_css_fields = [
                'slide_img' => [
                    'label' => esc_html__('Slide', 'et_builder'),
                    'selector' => '.slick-slide',
                ],
            ];
            return $custom_css_fields;
        }

        public function get_advanced_fields_config()
        {
            $advanced_fields = [];
            $advanced_fields['border'] = [];
            $advanced_fields['animation'] = [];
            $advanced_fields['margin_padding'] = [
                'css' => [
                    'padding' => "{$this->main_css_element}",
                    'margin' => "{$this->main_css_element}",
                ],

            ];
            $advanced_fields['background'] = [
                'css' => array(
                    'main' => "{$this->main_css_element}",
                ),
            ];
            return $advanced_fields;
        }

        public function get_fields()
        {
            return [
                'slider_speed' => [
                    'label' => esc_html__('Scroll speed (milliseconds)', 'et_builder'),
                    'type' => 'range',
                    'option_category' => 'layout',
                    'default' => '3000',
                    'default_unit' => '',
                    'range_settings' => [
                        'min' => '250',
                        'max' => '20000',
                        'step' => '250',
                    ],
                    'tab_slug' => 'advanced',
                ],
                'module_id' => [
                    'label' => __('CSS ID', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'tab_slug' => 'custom_css',
                    'option_class' => 'et_pb_custom_css_regular',
                ],
                'module_class' => [
                    'label' => __('CSS Class', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'tab_slug' => 'custom_css',
                    'option_class' => 'et_pb_custom_css_regular',
                ],
                'show_arrows' => [
                    'label' => 'Show Arrows',
                    'type' => 'yes_no_button',
                    'options' => [
                        'off' => esc_html__('No', 'et_builder'),
                        'on' => esc_html__('Yes', 'et_builder'),
                    ],
                ],
                'show_dots' => [
                    'label' => 'Show Dots',
                    'type' => 'yes_no_button',
                    'options' => [
                        'off' => esc_html__('No', 'et_builder'),
                        'on' => esc_html__('Yes', 'et_builder'),
                    ],
                ],
                'fullscreen' => [
                    'label' => 'Show Fullscreen',
                    'type' => 'yes_no_button',
                    'options' => [
                        'off' => esc_html__('No', 'et_builder'),
                        'on' => esc_html__('Yes', 'et_builder'),
                    ],
                ],
                'min_imgs' => [
                    'label' => __('Minimum Images', 'et_builder'),
                    'type' => 'range',
                    'default' => '5',
                    'default_unit' => '',
                    'range_settings' => [
                        'min' => '1',
                        'max' => '20',
                        'step' => '1',
                    ],

                ],
                'field_name' => [
                    'label' => __('Field Name Override', 'et_builder'),
                    'type' => 'text',
                    'default' => 'gallery',
                    'option_category' => 'layout',
                    'tab_slug' => 'advanced',
                    'description' => 'The name of the ACF gallery field you are targeting',
                ],
            ];
        }

        public function i_need_images($image_ids, $min_images = 5)
        {
            if (count($image_ids) < $min_images) {
                $image_ids = array_merge($image_ids, $image_ids);
                $image_ids = $this->i_need_images($image_ids, $min_images);
                return $image_ids;
            } else {
                return $image_ids;
            }

        }
        public function numbers_only($input)
        {
            $output = preg_replace('/\D/', '', $input);
            return $output;
        }

        public function render($atts, $content, $render_slug)
        {
            $module_id = $this->props['module_id'];
            $module_class = $this->props['module_class'];
            $show_dots = $this->props['show_dots'];
            $show_arrows = $this->props['show_arrows'];
            $fullscreen = $this->props['fullscreen'];
            $min_imgs = $this->props['min_imgs'];
            $field_name = $this->props['field_name'];
            $slider_speed = $this->props['slider_speed'];

            if($field_name == ''){
                $image_ids = get_field('gallery', FALSE, FALSE);
            }else{
                $image_ids = get_field($field_name, FALSE, FALSE);
            }

            if ("" == $image_ids) {
                return;
            }

            if($slider_speed == ''){
                $slider_speed = true;
            }else{
                $slider_speed = $this->numbers_only($slider_speed);
            }

            $module_class = trim(ET_Builder_Element::add_module_order_class($module_class, $render_slug));

            $image_ids = $this->i_need_images($image_ids, $this->numbers_only($min_imgs));

            $images = "";

            foreach ($image_ids as $image) {
                $img = wp_get_attachment_image_src($image, 'large');
                $image_alt = get_post_meta($image, '_wp_attachment_image_alt', TRUE);
                $image_title = get_the_title($image);
                $images .= "<img class='carousel-image' data-flickity-lazyload='$img[0]' alt='$image_alt' title='$image_title'/>";
            }

            $output = sprintf(
                '<div %1$s class="carousel %2$s" 
                data-flickity=\'{ "lazyLoad": 4,  "wrapAround": true, "autoPlay": %7$s, %4$s %5$s %6$s }\'>
                %3$s
            </div>',
                ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
                ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : ''),
                $images,
                ('on' == $show_dots ? '"pageDots": true,' : '"pageDots": false,'),
                ('on' == $show_arrows ? '"prevNextButtons": true,' : '"prevNextButtons": false,'),
                ('on' == $fullscreen ? '"fullscreen": true' : '"fullscreen": false'),
                $slider_speed
            );


            wp_enqueue_script('Flickity', $path = $this->assetUrl('flickity.pkgd.min.js'));
            wp_enqueue_style('Flickity', $this->assetUrl('flickity.css'));

            wp_enqueue_style('Flickity-module', $this->assetUrl('module.css'), [], '1.1.6' );
            if($fullscreen == 'on'){
                wp_enqueue_script('Flickity_FS', $path = $this->assetUrl('fullscreen.js'));
                wp_enqueue_style('Flickity_FS', $this->assetUrl('fullscreen.css'));
            }

            return $output;
        }
    }
