<?php

    namespace Optimus\Divi\Modules\FlickityInlineGallerySlider;

    use Optimus\Divi\Modules\BaseModule as DiviModule;
    use ET_Builder_Element;

    class Module extends DiviModule
    {
        public $name = 'Flickity Inline Gallery Slider';

        public function init()
        {
            $this->slug = 'flickity-inline-gallery-slider';
            parent::init();
        }

        public function getCustomCSSOptions()
        {
            $custom_css_fields = [];
            return $custom_css_fields;
        }

        public function get_advanced_fields_config()
        {
            $advanced_fields = [];
            $advanced_fields['border'] = [];
            $advanced_fields['animation'] = [];
            $advanced_fields['margin_padding'] = [
                'css' => [
                    'padding' => "{$this->main_css_element}",
                    'margin' => "{$this->main_css_element}",
                ],

            ];
            $advanced_fields['background'] = [
                'css' => array(
                    'main' => "{$this->main_css_element}",
                ),
            ];
            return $advanced_fields;
        }

        public function get_fields()
        {
            return [
                'gallery_ids' => array(
                    'label' => esc_html__('Gallery Images', 'et_builder'),
                    'type' => 'upload-gallery',
                    'computed_affects' => array(
                        '__gallery',
                    ),
                    'option_category' => 'basic_option',
                    'toggle_slug' => 'main_content',
                ),
                'gallery_orderby' => array(
                    'label' => esc_html__('Gallery Images', 'et_builder'),
                    'type' => 'hidden',
                    'class' => array('et-pb-gallery-ids-field'),
                    'computed_affects' => array(
                        '__gallery',
                    ),
                    'toggle_slug' => 'main_content',
                ),
                'gallery_captions' => array(
                    'type' => 'hidden',
                    'class' => array('et-pb-gallery-captions-field'),
                    'computed_affects' => array(
                        '__gallery',
                    ),
                ),
                'slider_speed' => [
                    'label' => esc_html__('Scroll speed (milliseconds)', 'et_builder'),
                    'type' => 'range',
                    'option_category' => 'layout',
                    'default' => '3000',
                    'default_unit' => '',
                    'default_on_front' => '',
                    'range_settings' => [
                        'min' => '250',
                        'max' => '20000',
                        'step' => '250',
                    ],
                    'tab_slug' => 'advanced',
                ],
                'slider_height' => [
                    'label' => esc_html__('Slider Height (px)', 'et_builder'),
                    'type' => 'range',
                    'option_category' => 'layout',
                    'default' => '300',
                    'default_unit' => 'px',
                    'range_settings' => [
                        'min' => '50',
                        'max' => '1000',
                        'step' => '1',
                    ],
                    'tab_slug' => 'advanced',
                    'mobile_options' => TRUE,
                    'responsive' => TRUE,
                ],

                'module_id' => [
                    'label' => __('CSS ID', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'tab_slug' => 'custom_css',
                    'option_class' => 'et_pb_custom_css_regular',
                ],
                'module_class' => [
                    'label' => __('CSS Class', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'tab_slug' => 'custom_css',
                    'option_class' => 'et_pb_custom_css_regular',
                ],
                'show_arrows' => [
                    'label' => 'Show Arrows',
                    'type' => 'yes_no_button',
                    'options' => [
                        'off' => esc_html__('No', 'et_builder'),
                        'on' => esc_html__('Yes', 'et_builder'),
                    ],
                ],
                'show_dots' => [
                    'label' => 'Show Dots',
                    'type' => 'yes_no_button',
                    'options' => [
                        'off' => esc_html__('No', 'et_builder'),
                        'on' => esc_html__('Yes', 'et_builder'),
                    ],
                ],
                'fullscreen' => [
                    'label' => 'Enable Fullscreen button',
                    'type' => 'yes_no_button',
                    'options' => [
                        'off' => esc_html__('No', 'et_builder'),
                        'on' => esc_html__('Yes', 'et_builder'),
                    ],
                ],

            ];
        }

        public function numbers_only($input)
        {
            $output = preg_replace('/\D/', '', $input);
            return $output;
        }

        public function render($atts, $content, $render_slug)
        {
            $module_id = $this->props['module_id'];
            $module_class = $this->props['module_class'];
            $show_dots = $this->props['show_dots'];
            $show_arrows = $this->props['show_arrows'];
            $slider_height_vals = et_pb_responsive_options()->get_property_values($this->props, 'slider_height');
            $fullscreen = $this->props['fullscreen'];
            $gallery_ids = $this->props['gallery_ids'];
            $slider_speed = $this->props['slider_speed'];

            $module_class = trim(ET_Builder_Element::add_module_order_class($module_class, $render_slug));

            $image_ids = explode(',', $gallery_ids);

            $images = "";

            foreach ($image_ids as $image) {
                $img = wp_get_attachment_image_src($image, 'large');
                $images .= "<img class='carousel-image'
      data-flickity-lazyload='$img[0]' />";
            }

            foreach ($image_ids as $image) {
                $img = wp_get_attachment_image($image, 'large', "", array("class" => "carousel-image"));
                $images .= $img;
            }

            if ($slider_speed == "") {
                $slider_speed = 'true';
            } else {
                $slider_speed = $this->numbers_only($slider_speed);
            }

            $output = sprintf(
                '<div %1$s class="carousel %2$s" 
                data-flickity=\'{ %4$s "lazyLoad": 6, "autoPlay": %7$s, "wrapAround": true,  %4$s %5$s %6$s }\'>
                %3$s
            </div>',
                ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
                ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : ''),
                $images,
                ('on' == $fullscreen ? '"fullscreen": true,' : '"fullscreen": false,'),
                ('on' == $show_dots ? '"pageDots": true,' : '"pageDots": false,'),
                ('on' == $show_arrows ? '"prevNextButtons": true' : '"prevNextButtons": false'),
                $slider_speed

            );

            // Slider Height
            $slide_image_selector = '%%order_class%% .carousel-image';

            et_pb_responsive_options()->generate_responsive_css($slider_height_vals, $slide_image_selector, 'height', $render_slug);


            wp_enqueue_script('Flickity', $path = $this->assetUrl('flickity.pkgd.min.js'));
            wp_enqueue_style('Flickity', $this->assetUrl('flickity.css', [], '1.0.2'));

            if ($fullscreen) {
                wp_enqueue_script('Flickity-fullscreen', $path = $this->assetUrl('fullscreen.js'));
                wp_enqueue_style('Flickity-fullscreen', $this->assetUrl('fullscreen.css', [], '1.0.2'));
            }

            wp_enqueue_style('Flickity-module', $this->assetUrl('module.css'), [], '1.0.1');

            return $output;
        }
    }
