<?php

namespace Optimus\Divi\Modules\FullwidthBreadcrumbs;

use Optimus\Divi\Modules\BaseModule as DiviModule;
use ET_Builder_Element;

class Module extends DiviModule
{
    public $name = 'Fullwidth Breadcrumbs';

    public function init()
    {
        $this->child_slug = $this->slugify('Fullwidth Breadcrumb');
        $this->child_item_text = 'Breadcrumb';
        $this->fullwidth = true;

        parent::init();
    }

    public function fields()
    {
        return [
            'disabled_on' => [
                'label' => __('Disable on', 'et_builder'),
                'type' => 'multiple_checkboxes',
                'options' => [
                    'phone' => __('Phone', 'et_builder'),
                    'tablet' => __('Tablet', 'et_builder'),
                    'desktop' => __('Desktop', 'et_builder'),
                ],
                'additional_att' => 'disable_on',
                'option_category' => 'configuration',
                'description' => __('This will disable the module on selected devices', 'et_builder'),
            ],
            'admin_label' => [
                'label' => __('Admin Label', 'et_builder'),
                'type' => 'text',
                'description' => __(
                    'This will change the label of the module in the builder for easy identification.',
                    'et_builder'
                ),
            ],
            'module_id' => [
                'label' => __('CSS ID', 'et_builder'),
                'type' => 'text',
                'option_category' => 'configuration',
                'tab_slug' => 'custom_css',
                'option_class' => 'et_pb_custom_css_regular',
            ],
            'module_class' => [
                'label' => __('CSS Class', 'et_builder'),
                'type' => 'text',
                'option_category' => 'configuration',
                'tab_slug' => 'custom_css',
                'option_class' => 'et_pb_custom_css_regular',
            ],
        ];
    }

    public function shortcode_callback($atts, $content, $function_name)
    {
        $module_id = $this->shortcode_atts['module_id'];
        $module_class = $this->shortcode_atts['module_class'];

        $module_class = ET_Builder_Element::add_module_order_class($module_class, $function_name);

        $breadcrumbs = $this->shortcode_content;

        $output = sprintf(
            '<div %2$s class="%3$s">
                <ul id="breadcrumb" class="breadcrumbs clearfix">
                    %1$s 
                </ul>
            </div>',
            $breadcrumbs,
            ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
            ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : '')
        );

        wp_enqueue_style('breadcrumbs', $this->assetUrl('breadcrumbs.css'));

        return $output;
    }
}
