jQuery(document).ready(function () {
    const $maps = jQuery('.block.maps .content .map_canvas');

    $maps.each(function (index, element) {
        const $map = jQuery(element);
        const $infotext = $map.children('.infotext');

        if (!$infotext.length) return;

        // Parse styles safely
        let snazzy = [];
        try {
            snazzy = JSON.parse(typeof snazzy_style !== 'undefined' ? snazzy_style : '[]');
        } catch (e) {
            console.warn('Invalid snazzy_style JSON');
        }

        const icon = $infotext.children('.marker_src').text().trim();
        const iconSize = parseInt($infotext.children('.marker_size').text().trim(), 10) || 40;
        const address = $infotext.children('.address').text().trim();
        const zoom = parseInt($infotext.children('.zoom').text().trim(), 10) || 14;
        const disableControls = $infotext.children('.controls').text().trim() === 'true';

        const myOptions = {
            zoom: zoom,
            mapTypeId: google.maps.MapTypeId.ROADMAP,
            mapTypeControl: false,
            disableDefaultUI: disableControls,
            styles: snazzy,
            scrollwheel: false,
        };

        const geocoder = new google.maps.Geocoder();

        geocoder.geocode({ address: address }, function (results, status) {
            if (status === google.maps.GeocoderStatus.OK) {
                const location = results[0].geometry.location;
                myOptions.center = location;

                const map = new google.maps.Map(element, myOptions);

                const marker = new google.maps.Marker({
                    map: map,
                    position: location,
                    icon: {
                        url: icon,
                        scaledSize: new google.maps.Size(iconSize, iconSize)
                    }
                });

                // Custom click actions
                const clickAction = $infotext.children('.marker_click').text().trim() || 'none';
                const url = $infotext.children('.custom_url').text().trim();
                const placeName = $infotext.children('.place_name').text().trim();
                const placeId = $infotext.children('.place_id').text().trim();
                const lat = $infotext.children('.latitude').text().trim();
                const lng = $infotext.children('.longitude').text().trim();
                const infoWindowContent = $infotext.children('.info_content').html();

                let infoWindow = null;
                if (clickAction === 'popup' && infoWindowContent) {
                    infoWindow = new google.maps.InfoWindow({
                        content: infoWindowContent
                    });
                }

                google.maps.event.addListener(marker, 'click', function () {
                    console.log(clickAction);
                    switch (clickAction) {
                        case 'popup':
                            if (infoWindow) {
                                infoWindow.open(map, marker);
                            }
                            break;
                        case 'open_url':
                            if (url) {
                                window.open(url, '_blank');
                            }
                            break;
                        case 'open_place_name':
                            if (placeName) {
                                const query = encodeURIComponent(placeName);
                                window.open(`https://www.google.com/maps/search/?api=1&query=${query}`, '_blank');
                            }
                            break;
                        case 'open_place_id':
                            if (placeId) {
                                window.open(`https://www.google.com/maps/place/?q=place_id:${placeId}`, '_blank');
                            }
                            break;
                        case 'open_latlng':
                            if (lat && lng) {
                                window.open(`https://www.google.com/maps/@${lat},${lng},15z`, '_blank');
                            }
                            break;
                        default:
                            // No action
                            break;
                    }
                });
            } else {
                console.warn('Geocode was not successful: ' + status);
            }
        });
    });
});