<?php

    namespace Optimus\Divi\Modules\HeadingRotator;

    use Optimus\Divi\Modules\BaseModule as DiviModule;
    use ET_Builder_Element;

    class Item extends DiviModule
    {
        public $name = 'Heading Rotator Item';

        public function init()
        {
            $this->type                        = 'child';
            $this->child_title_var             = 'title';
            $this->advanced_setting_title_text = 'Rotator Item';
            $this->settings_text               = 'Rotator Item Settings';

            parent::init();
        }

        public function get_advanced_fields_config() {
            $advanced_fields = [];
            $advanced_fields['box_shadow'] = FALSE;
            $advanced_fields['border'] = [];
            $advanced_fields['animation'] = FALSE;
            $advanced_fields['fonts']['header_rotate'] = [
                'label' => "Rotate",
                'css' => [
                    'main' => "{$this->main_css_element}",
                ],
                'line_height' => [
                    'default' => '1.2em',
                ],
            ];
            return $advanced_fields;
        }

        public function fields()
        {
            return [
                'title' => [
                    'label' => 'Text',
                    'type'  => 'text',
                ]
            ];
        }

        public function render($atts, $content, $function_name)
        {
            global $et_pb_tab_titles;
            global $et_pb_tab_classes;

            $title        = $this->props['title'];
            $module_class = ET_Builder_Element::add_module_order_class('', $function_name);

            $et_pb_tab_titles[]  = '' !== $title ? $title : __('Tab', 'et_builder');
            $et_pb_tab_classes[] = $module_class;

            $output = sprintf(
                '<p><span class="et_pb_heading_rotator_item%2$s">%1$s</span></p>',
                $title,
                $module_class
            );

            return $output;
        }
    }
