<?php

    namespace Optimus\Divi\Modules\HeadingRotator;

    use Optimus\Divi\Modules\BaseModule as DiviModule;
    use ET_Builder_Element;

    class Module extends DiviModule
    {
        public $name = 'Heading Rotator';

        public function init()
        {
            $this->child_slug = $this->slugify('Heading Rotator Item');
            $this->child_item_text = 'Rotator Item';

            parent::init();
        }

        public function get_advanced_fields_config() {
            $advanced_fields = [];
            $advanced_fields['box_shadow'] = [];
            $advanced_fields['border'] = [];
            $advanced_fields['animation'] = [];
            $advanced_fields['fonts']['header_prefix'] = [
                'label' => "Header Prefix",
                'css' => [
                    'main' => "{$this->main_css_element} h1 span.prefix",
                ],
                'line_height' => [
                    'default' => '1.2em',
                ],
            ];
            $advanced_fields['fonts']['header_rotate'] = [
                'label' => "Header Rotate",
                'css' => [
                    'main' => "{$this->main_css_element} h1 span.rotate ",
                ],
                'line_height' => [
                    'default' => '1.2em',
                ],
            ];
            $advanced_fields['fonts']['header_suffix'] = [
                'label' => "Header suffix",
                'css' => [
                    'main' => "{$this->main_css_element} h1 span.suffix ",
                ],
                'line_height' => [
                    'default' => '1.2em',
                ],
            ];
            return $advanced_fields;
        }


        public function fields()
        {
            return [
                'prefix' => [
                    'label' => 'Prefix This',
                    'type' => 'text',
                    'description' => 'Text to add Before the rotator',
                ],
                'suffix' => [
                    'label' => 'Suffix',
                    'type' => 'text',
                    'description' => 'Text to add After the rotator',
                ],
                'text_orientation' => [
                    'label' => esc_html__('Text Orientation', 'et_builder'),
                    'type' => 'select',
                    'option_category' => 'layout',
                    'options' => et_builder_get_text_orientation_options(),
                    'description' => esc_html__('This will control how your blurb text is aligned.', 'et_builder'),
                ],
                'disabled_on' => [
                    'label' => __('Disable on', 'et_builder'),
                    'type' => 'multiple_checkboxes',
                    'options' => [
                        'phone' => __('Phone', 'et_builder'),
                        'tablet' => __('Tablet', 'et_builder'),
                        'desktop' => __('Desktop', 'et_builder'),
                    ],
                    'additional_att' => 'disable_on',
                    'option_category' => 'configuration',
                    'description' => __('This will disable the module on selected devices', 'et_builder'),
                ],
                'admin_label' => [
                    'label' => __('Admin Label', 'et_builder'),
                    'type' => 'text',
                    'description' => __(
                        'This will change the label of the module in the builder for easy identification.',
                        'et_builder'
                    ),
                ],
                'module_id' => [
                    'label' => __('CSS ID', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'tab_slug' => 'custom_css',
                    'option_class' => 'et_pb_custom_css_regular',
                ],
                'module_class' => [
                    'label' => __('CSS Class', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'tab_slug' => 'custom_css',
                    'option_class' => 'et_pb_custom_css_regular',
                ],
            ];
        }

        public function render($atts, $content, $function_name)
        {
            $module_id = $this->props['module_id'];
            $module_class = $this->props['module_class'];
            $prefix = $this->props['prefix'];
            $suffix = $this->props['suffix'];
            $text_orientation = $this->props['text_orientation'];

            $module_class = ET_Builder_Element::add_module_order_class($module_class, $function_name);
            $module_class_selector = '.'.ltrim($module_class);
            $rotatorItems = $this->content;

            $output = sprintf(
                '<div class="%5$s et_pb_heading_rotator" %4$s>
                <h1 class="heading-rotator %7$s">
                    %2$s <span class="rotate"></span> %3$s
                </h1>	
                <div id="typed-strings" style="display: none;"> %1$s </div>
            </div>
            <script type="text/javascript"> 
            jQuery(function($){ 
                $("%6$s .rotate").typed({
                    stringsElement: $("%6$s #typed-strings"),
                    typeSpeed: 35,
                    backSpeed: 0,
                    startDelay: 200,
                    backDelay: 1500,
                    loop: true,
                    loopCount: false,
                    showCursor: true,
                    cursorChar: "|",
                    attr: null
                });
            });
            </script>',
                $rotatorItems,
                ('' !== $prefix ? sprintf('<span class="prefix">%1$s</span>', esc_attr($prefix)) : ''),
                ('' !== $suffix ? sprintf('<span class="suffix">%1$s</span>', esc_attr($suffix)) : ''),
                ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
                ('' !== $module_class ? sprintf('%1$s', esc_attr($module_class)) : ''),
                ('' !== $module_class_selector ? $module_class_selector : ''),
                ('' !== $text_orientation ? sprintf(' et_pb_text_align_%1$s', esc_attr($text_orientation)) : '')
            );

            if (!is_admin()) {
                wp_enqueue_script('typed', $this->assetUrl('typed.min.js'));
                wp_enqueue_style('headingRotator', $this->assetUrl('heading-rotator.css'));
            }

            return $output;
        }
    }
