<?php

namespace Optimus\Divi\Modules\HoverTile;

use Optimus\Divi\Modules\BaseModule as DiviModule;
use ET_Builder_Element;

class Module extends DiviModule
{
    public $name = 'Hover Tile';

    public function init()
    {
        $this->advanced_fields = [
            'fonts' => [
                'title' => [
                    'label' => esc_html__('Title', 'et_builder'),
                    'default' => '30px',
                    'css' => [
                        'main' => "{$this->main_css_element} figcaption H2",
                    ],
                    'font_size' => [
                        'default' => '30px',
                    ],
                ],
                'caption' => [
                    'label' => esc_html__('Caption', 'et_builder'),
                    'css' => [
                        'main' => "{$this->main_css_element} figcaption p",
                    ],
                    'font_size' => [
                        'default' => '16px',
                    ],
                ],
            ],
            'background' => [
                'use_background_image' => false,
                'css' => [
                    'main' => "div{$this->main_css_element} figure",
                    'important' => 'all',
                ],
                'settings' => [
                    'color' => 'alpha',
                ],
            ],
            'custom_margin_padding' => [
                'use_padding' => false,
                'css' => [
                    'main' => "div{$this->main_css_element} figure",
                    'important' => 'all',
                ],
            ],
        ];
        $this->custom_css_fields = [];

        parent::init();
    }

    public function fields()
    {
        return [
            'title' => [
                'label' => 'Title',
                'type' => 'text',
            ],
            'content' => [
                'label' => esc_html__('Content', 'et_builder'),
                'type' => 'tiny_mce',
                'option_category' => 'basic_option',
                'description' => esc_html__('Here you can create the content that will be used within the module.', 'et_builder'),
            ],
            'bg_img' => [
                'label' => esc_html__('Image URL', 'et_builder'),
                'type' => 'upload',
                'option_category' => 'basic_option',
                'upload_button_text' => esc_attr__('Upload an image', 'et_builder'),
                'choose_text' => esc_attr__('Choose an Image', 'et_builder'),
                'update_text' => esc_attr__('Set As Image', 'et_builder'),
                'description' => esc_html__('Upload your desired image, or type in the URL to the image you would like to display.', 'et_builder'),
            ],
            'background_layout' => [
                'label' => esc_html__('Text Color', 'et_builder'),
                'type' => 'select',
                'option_category' => 'color_option',
                'options' => [
                    'dark' => esc_html__('Light', 'et_builder'),
                    'light' => esc_html__('Dark', 'et_builder'),
                ],
                'description' => esc_html__('Here you can choose whether your text should be light or dark. If you are working with a dark background, then your text should be light. If your background is light, then your text should be set to dark.', 'et_builder'),
            ],
            'admin_label' => [
                'label' => __('Admin Label', 'et_builder'),
                'type' => 'text',
                'description' => __('This will change the label of the module in the builder for easy identification.', 'et_builder'),
            ],
            'module_id' => [
                'label' => __('CSS ID', 'et_builder'),
                'type' => 'text',
                'option_category' => 'configuration',
                'tab_slug' => 'custom_css',
                'option_class' => 'et_pb_custom_css_regular',
            ],
            'module_class' => [
                'label' => __('CSS Class', 'et_builder'),
                'type' => 'text',
                'option_category' => 'configuration',
                'tab_slug' => 'custom_css',
                'option_class' => 'et_pb_custom_css_regular',
            ],
        ];
    }

    public function shortcode_callback($atts, $content, $function_name)
    {
        $module_class = $this->shortcode_atts['module_class'];
        $module_class = ET_Builder_Element::add_module_order_class($module_class, $function_name);
        $title = $this->shortcode_atts['title'];
        $bg_img = $this->shortcode_atts['bg_img'];
        $link = $this->shortcode_atts['link'];

        $background_layout = $this->shortcode_atts['background_layout'];
        $background_class = " et_pb_bg_layout_{$background_layout}";
        $this->shortcode_content = et_builder_replace_code_content_entities($this->shortcode_content);

        $output = sprintf(
            '<div class="et_pb_hover_tile'.$module_class.' %4$s">
                <figure>
                    <img src="%3$s"/>
                    <figcaption>
                        <div><h2>%1$s</h2>%2$s</div>
                        <a href="%5$s">View more</a>
                    </figcaption>			              
                </figure>
            </div>',
            $title,
            $this->shortcode_content,
            $bg_img,
            $background_class,
            $link
        );

        if (!is_admin()) {
            wp_enqueue_style('tile', $this->assetUrl('tile.css'));
        }

        return $output;
    }
}
