<?php

    namespace Optimus\Divi\Modules\LoginForm;

    use Optimus\Divi\Modules\BaseModule as DiviModule;
    use ET_Builder_Element;

    class Module extends DiviModule
    {
        public $name = 'Login Form';

        public function init()
        {
            parent::init();
        }

        public function advancedOptions()
        {
            return [
                'button' => [
                    'button' => [
                        'label' => esc_html__('Button', 'et_builder'),
                        'css' => [
                            'main' => "{$this->main_css_element} #divi-wp-submit",
                        ],
                    ],
                ],
            ];
        }

        public function fields()
        {
            return [
                'redirect' => [
                    'label' => __('Redirect To', 'et_builder'),
                    'type' => 'text',
                    'description' => 'Leave blank for redirect to this page',
                ],
                'label_username' => [
                    'label' => 'Label Username',
                    'type' => 'text',
                    'default' => 'Username or Email Address',
                ],
                'label_password' => [
                    'label' => 'Label Password',
                    'type' => 'text',
                    'default' => 'Password',
                ],
                'style' => [
                    'label' => esc_html__('Add Styles', 'et_builder'),
                    'type' => 'select',
                    'option_category' => 'configuration',
                    'options' => [
                        'light' => esc_html__('Light', 'et_builder'),
                        'dark' => esc_html__('Dark', 'et_builder'),
                        'off' => esc_html__('No Styles', 'et_builder'),
                    ],
                ],
                'button_pos' => [
                    'label' => esc_html__('Button Position', 'et_builder'),
                    'type' => 'select',
                    'tab_slug' => 'advanced',
                    'options' => [
                        'right' => esc_html__('Right', 'et_builder'),
                        'left' => esc_html__('Left', 'et_builder'),
                    ],
                ],
                'admin_label' => [
                    'label' => __('Admin Label', 'et_builder'),
                    'type' => 'text',
                    'description' => __('This will change the label of the module in the builder for easy identification.',
                        'et_builder'),
                ],
                'module_id' => [
                    'label' => __('CSS ID', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'tab_slug' => 'custom_css',
                    'option_class' => 'et_pb_custom_css_regular',
                ],
                'module_class' => [
                    'label' => __('CSS Class', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'tab_slug' => 'custom_css',
                    'option_class' => 'et_pb_custom_css_regular',
                ],
            ];
        }

        function add_lost_password_link()
        {
            return '<a class="lost_pass" href="/wp-login.php?action=lostpassword">Lost Password?</a>';
        }

        public function shortcode_callback($atts, $content, $function_name)
        {
            add_action('login_form_middle', array($this, 'add_lost_password_link'));
            $module_id = $this->shortcode_atts['module_id'];
            $module_class = $this->shortcode_atts['module_class'];
            $redirect = $this->shortcode_atts['redirect'];
            $label_username = $this->shortcode_atts['label_username'];
            $label_password = $this->shortcode_atts['label_password'];

            $style = $this->shortcode_atts['style'];
            $select = $this->shortcode_atts['select'];
            $button_pos = $this->shortcode_atts['button_pos'];
            if ($redirect == "") {
                $redirect = get_site_url(). $_SERVER['REQUEST_URI'];
            }

            $args = array(
                'echo' => FALSE,
                'remember' => TRUE,
                'redirect' => $redirect,
                'form_id' => 'loginform',
                'id_username' => 'user_login',
                'id_password' => 'user_pass',
                'id_remember' => 'rememberme',
                'id_submit' => 'divi-wp-submit',
                'label_username' => $label_username,
                'label_password' => $label_password,
                'label_remember' => __('Remember Me'),
                'label_log_in' => __('Log In'),
                'value_username' => '',
                'value_remember' => FALSE
            );
            $form = wp_login_form($args);


            $module_class = ET_Builder_Element::add_module_order_class($module_class, $function_name);

            // Default Styles
            ET_Builder_Element::set_style($function_name, [
                'selector' => '%%order_class%% .et_pb_contact_submit',
                'declaration' => "float: $button_pos;",
            ]);

            $output = sprintf(
                '<div %2$s class="et_pb_login_form %3$s %4$s clearfix">
				%1$s
			</div>',
                $form,
                ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
                ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : ''),
                ('' !== $style ? sprintf(' form_%1$s', esc_attr($style)) : '')
            );

            if (is_admin()) {
            } else {
                wp_enqueue_style('loginform', $this->assetUrl('loginModule.css'));
            }
            return $output;


        }
    }