<?php

    namespace Optimus\Divi\Modules\LogoSlider;

    use Optimus\Divi\Modules\BaseModule as DiviModule;
    use ET_Builder_Element;

    class Module extends DiviModule
    {
        public $name = 'Logo Slider';

        public function init()
        {
            $this->child_slug = $this->slugify('Logo Slide');
            $this->child_item_text = 'Logo Slide';
            parent::init();
        }

        public function getCustomCSSOptions()
        {
            $custom_css_fields = [
                'slide_img' => [
                    'label' => esc_html__('Slide', 'et_builder'),
                    'selector' => '.slick-slide',
                ],
            ];
            return $custom_css_fields;
        }

        public function get_advanced_fields_config() {
            $advanced_fields = [];
            $advanced_fields['border'] = [];
            $advanced_fields['animation'] = [];
            $advanced_fields['margin_padding'] = [
                'css'        => [
                    'padding'   => "{$this->main_css_element} .slick-slide",
                    'margin'    => "{$this->main_css_element} .slick-slide",
                ],

            ];
            $advanced_fields['background'] = [
                'css' => array(
                    'main' => "{$this->main_css_element} .slick-slide",
                ),
            ];
            return $advanced_fields;
        }

        public function get_fields()
        {
            return [
                'slider_speed' => [
                    'label' => esc_html__('Scroll speed (milliseconds)', 'et_builder'),
                    'type' => 'range',
                    'option_category' => 'layout',
                    'default' => '2000',
                    'default_unit'    => '',
                    'range_settings' => [
                        'min' => '250',
                        'max' => '20000',
                        'step' => '250',
                    ],
                    'tab_slug' => 'advanced',
                ],
                'slides_to_show' => [
                    'label' => esc_html__('Slides to show', 'et_builder'),
                    'type'            => 'range',
                    'option_category' => 'layout',
                    'default' => '4',
                    'mobile_options'  => true,
                    'tab_slug'        => 'advanced',
                    'responsive'      => true,
                    'default_unit'    => '',
                    'range_settings' => [
                        'min' => '0',
                        'max' => '10',
                        'step' => '.1',
                    ],
                ],
                'module_id' => [
                    'label' => __('CSS ID', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'tab_slug' => 'custom_css',
                    'option_class' => 'et_pb_custom_css_regular',
                ],
                'module_class' => [
                    'label' => __('CSS Class', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'tab_slug' => 'custom_css',
                    'option_class' => 'et_pb_custom_css_regular',
                ],
                'randomize_order_on_pageload' => [
                    'label' => esc_html__('Randomize order of slides on page load', 'et_builder'),
                    'type' => 'yes_no_button',
                    'options' => [
                        'off' => esc_html__('No', 'et_builder'),
                        'on' => esc_html__('Yes', 'et_builder'),
                    ],
                ],
                'vertically_center' => [
                    'label' => esc_html__('Vertically center slides using flexbox', 'et_builder'),
                    'type' => 'yes_no_button',
                    'options' => [
                        'off' => esc_html__('No', 'et_builder'),
                        'on' => esc_html__('Yes', 'et_builder'),
                    ],
                ],
                'smooth' => [
                    'label' => esc_html__('Smooth Scroll', 'et_builder'),
                    'type' => 'yes_no_button',
                    'options' => [
                        'off' => esc_html__('No', 'et_builder'),
                        'on' => esc_html__('Yes', 'et_builder'),
                    ],
                    'tab_slug' => 'advanced',
                ],
                'show_dots' => [
                    'label' => esc_html__('Show Nav Dots', 'et_builder'),
                    'type' => 'yes_no_button',
                    'options' => [
                        'off' => esc_html__('No', 'et_builder'),
                        'on' => esc_html__('Yes', 'et_builder'),
                    ],
                    'tab_slug' => 'advanced',
                ],
                'show_arrows' => [
                    'label' => esc_html__('Show Nav Arrows', 'et_builder'),
                    'type' => 'yes_no_button',
                    'options' => [
                        'off' => esc_html__('No', 'et_builder'),
                        'on' => esc_html__('Yes', 'et_builder'),
                    ],
                    'tab_slug' => 'advanced',
                ],
                'grey_out' => [
                    'label' => esc_html__('Grey Out Logos', 'et_builder'),
                    'type' => 'select',
                    'option_category' => 'configuration',
                    'options' => [
                        '' => esc_html__('Never', 'et_builder'),
                        'grayscale' => esc_html__('Always', 'et_builder'),
                        'grayscale_hover' => esc_html__('On Hover', 'et_builder'),
                        'grayscale_hover_alt' => esc_html__('Not Hovered', 'et_builder'),
                    ],
                    'tab_slug' => 'advanced',
                ],
            ];
        }

        public function render($atts, $content, $render_slug)
        {
            $module_id = $this->props['module_id'];
            $module_class = $this->props['module_class'];
            $grey_out = $this->props['grey_out'];
            $show_dots = $this->props['show_dots'];
            $show_arrows = $this->props['show_arrows'];
            $module_class = trim(ET_Builder_Element::add_module_order_class($module_class, $render_slug));

            $slidesToShow = rtrim($this->props['slides_to_show'],"px");
            $slidesToShowtablet = rtrim($this->props['slides_to_show_tablet'],"px");
            $slidesToShowphone = rtrim($this->props['slides_to_show_phone'],"px");
            $randomizeOrder = isset($this->props['randomize_order_on_pageload']) && $this->props['randomize_order_on_pageload'] == 'on';
            $vertically_center = $this->props['vertically_center'];
            $logos = $this->content;
            $sliderSpeed = (isset($this->props['slider_speed']) && !empty($this->props['slider_speed'])) ? $this->props['slider_speed'] : 2000;
            $smooth_operator = $this->props['smooth'];

            $inline = sprintf('{ "slidesToShow": %1$s, "dots": %4$s, "autoplay": true, "arrows": %5$s, %6$s "responsive": [{ "breakpoint": 981,
			"settings": { "slidesToShow": %2$s } }, { "breakpoint": 768, "settings": { "slidesToShow": %3$s } } ] }',
                ('' !== $slidesToShow ?  $slidesToShow : 4),
                ('' !== $slidesToShowtablet ? $slidesToShowtablet : 3),
                ('' !== $slidesToShowphone ? $slidesToShowphone : 2),
                ('off' !== $show_dots ? 'true' : 'false'),
                ('off' !== $show_arrows ? 'true' : 'false'),
                ('on' == $smooth_operator ? sprintf('"speed": %1$d, "cssEase": "linear","autoplaySpeed": 0,', $sliderSpeed) : sprintf('"autoplaySpeed": %1$s,', $sliderSpeed)) );

            $output = sprintf(
                '<div %3$s class="%2$s et_pb_logo_slider %4$s %5$s %6$s" data-slick=\'%7$s\'> %1$s </div>',
                $logos,
                ('' !== $grey_out ? $grey_out : ''),
                ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
                ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : ''),
                ('' !== $vertically_center ? 'center_logos' : ''),
                $randomizeOrder ? 'random_order' : '',
                $inline
            );

            if(!is_admin()){
                wp_enqueue_script('logoslider', $this->assetUrl('logoslider.js'), ['jquery'], '1.4.0' );

                wp_enqueue_style('logoslider', $this->assetUrl('logoslider.css'));
                wp_enqueue_style('logoslidertheme', $this->assetUrl('logoslidertheme.css' ));
            }

            return $output;
        }
    }