<?php

    namespace Optimus\Divi\Modules\ModalButton;

    use Optimus\Divi\Modules\BaseModule as DiviModule;
    use ET_Builder_Element;

    class Module extends DiviModule
    {
        public $name = 'Modal Button';

        public function init()
        {
            $this->fields_defaults = [
                'url_new_window' => ['off'],
                'background_color' => [et_builder_accent_color(), 'add_default_setting'],
                'background_layout' => ['light'],
            ];

            $this->custom_css_fields = [
                'main_element' => [
                    'label' => esc_html__('Main Element', 'et_builder'),
                    'selector' => '.et_pb_button.et_pb_module',
                    'no_space_before_selector' => TRUE,
                ]
            ];

            parent::init();
        }

        public function getCustomCSSOptions()
        {
            $custom_css_fields = [];
            return $custom_css_fields;
        }

        public function get_advanced_fields_config()
        {
            $advanced_fields = [];
            $advanced_fields['button']['modal'] = [
                'label' => "Button",
                'css' => [
                    'main' => "{$this->main_css_element}",
                ],
            ];
            return $advanced_fields;
        }


        public function get_fields()
        {
            return [
                'button_text' => [
                    'label' => esc_html__('Button Text', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'basic_option',
                    'description' => esc_html__('Input your desired button text.', 'et_builder'),
                ],
                'button_alignment' => [
                    'label' => esc_html__('Button alignment', 'et_builder'),
                    'type' => 'select',
                    'option_category' => 'configuration',
                    'options' => [
                        'left' => esc_html__('Left', 'et_builder'),
                        'center' => esc_html__('Center', 'et_builder'),
                        'right' => esc_html__('Right', 'et_builder'),
                    ],
                    'description' => esc_html__('Here you can define the alignemnt of Button', 'et_builder'),
                ],
                'background_layout' => [
                    'label' => esc_html__('Text Color', 'et_builder'),
                    'type' => 'select',
                    'option_category' => 'color_option',
                    'options' => [
                        'light' => esc_html__('Dark', 'et_builder'),
                        'dark' => esc_html__('Light', 'et_builder'),
                    ],
                    'description' => esc_html__(
                        'Here you can choose whether your text should be light or dark. If you are working with a dark background, then your text should be light. If your background is light, then your text should be set to dark.',
                        'et_builder'
                    ),
                ],
                'modal_content' => [
                    'label' => esc_html__('Content', 'et_builder'),
                    'type' => 'tiny_mce',
                    'option_category' => 'basic_option',
                    'description' => 'Modal Content',
                ],
                'module_id' => [
                    'label' => esc_html__('CSS ID', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'tab_slug' => 'custom_css',
                    'option_class' => 'et_pb_custom_css_regular',
                ],
                'module_class' => [
                    'label' => esc_html__('CSS Class', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'tab_slug' => 'custom_css',
                    'option_class' => 'et_pb_custom_css_regular',
                ],
            ];
        }

        public function render($atts, $content, $render_slug)
        {
            $module_id = $this->props['module_id'];
            $module_class = $this->props['module_class'];
            $button_text = $this->props['button_text'];
            $background_layout = $this->props['background_layout'];
            $button_alignment = $this->props['button_alignment'];
            $modal_content = $this->props['modal_content'];

            // Nothing to output if neither Button Text nor Button URL defined
            if ('' === $button_text) {
                return "";
            }
            $module_class = trim(ET_Builder_Element::add_module_order_class($module_class, $render_slug));

            $module_class .= " et_pb_module et_pb_bg_layout_{$background_layout}";

            $output = sprintf(
                '<div class="et_pb_button_module_wrapper %5$s">
                <a class="et_pb_button et_pb_modal_button %4$s" href="javascript:void(0);" %3$s>%1$s</a>
                <div class="white-popup mfp-hide">%2$s</div>
            </div>',
                $button_text,
                $modal_content,
                ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
                ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : ''),
                ('right' === $button_alignment || 'center' === $button_alignment ? sprintf(' et_pb_button_alignment_%1$s', esc_attr($button_alignment)) : '')
            );

            wp_enqueue_style('optimus-divi-modal-button-module-style', $this->assetUrl('modal-button.css'));
            wp_enqueue_script('optimus-divi-modal-button-module-script', $this->assetUrl('scripts.js'));

            return $output;
        }
    }
