<?php

namespace Optimus\Divi\Modules\ParallaxColumns;

use Optimus\Divi\Modules\BaseModule as DiviModule;

class Item extends DiviModule
{
    public $name = 'Item';

    public function init()
    {
        $this->name = 'Item';
        $this->slug = 'et_pb_mw_pcols_item';
        $this->type = 'child';
        $this->child_title_var = 'title';
        $this->advanced_setting_title_text = 'Tile';
        $this->settings_text = 'Tile Settings';
        $this->main_css_element = '%%order_class%%';
        $this->advanced_options = [];
    }

    public function fields()
    {
        return [
            'src' => [
                'label' => __('Image URL', 'et_builder'),
                'type' => 'upload',
                'option_category' => 'basic_option',
                'upload_button_text' => __('Upload an image', 'et_builder'),
                'choose_text' => __('Choose an Image', 'et_builder'),
                'update_text' => __('Set As Image', 'et_builder'),
                'description' => __('Upload your desired image, or type in the URL to the image you would like to display.', 'et_builder'),
            ],
            'title' => [
                'label' => 'Text',
                'type' => 'text',
            ],
            'content_new' => [
                'label' => __('Content', 'et_builder'),
                'type' => 'tiny_mce',
                'option_category' => 'basic_option',
                'description' => __('Here you can create the content that will be used within the module.', 'et_builder'),
            ],
            'link' => [
                'label' => 'URL',
                'type' => 'text',
                'description' => 'Here you can define the url (optional).',
            ],
        ];
    }

    public function shortcode_callback($atts, $content, $function_name)
    {
        $title = $this->shortcode_atts['title'];
        $link = $this->shortcode_atts['link'];
        $content_new = $this->shortcode_content;
        $src = $this->shortcode_atts['src'];

        $output = sprintf(
            '<div class="item">
            %2$s 
                %5$s
                <h2>%1$s</h2>
                %4$s
            %3$s
            </div>',
            $title,
            ('' !== $link ? sprintf('<a href="%1$s">', $link) : ''),
            ('' !== $link ? '</a>' : ''),
            $content_new,
            ('' !== $src ? sprintf('<img src="%1$s">', $src) : '')
        );

        return $output;
    }
}
