// Add a wrapper div and split into two lists, and float them using CSS.     
jQuery('.et_pb_mw_boxedist').each(function () {
	listElements = jQuery(this).children('.item');
	leftColumn = listElements.slice(0, Math.ceil(listElements.length / 2)).clone();
	rightColumn = listElements.slice(Math.ceil(listElements.length / 2)).clone();
	parentDiv = jQuery(this);
	parentDiv.empty();
	jQuery(leftColumn).appendTo(parentDiv).wrapAll("<div class='left' />");
	jQuery(rightColumn).appendTo(parentDiv).wrapAll("<div class='right' />");
});

// Calculate on load, resize, and Scroll        
jQuery(window).on("load resize scroll", function (e) {
	var leftColumn = jQuery('.left');
	var leftColumnHeight = leftColumn.outerHeight();
	var rightColumn = jQuery('.right');
	var rightColumnHeight = rightColumn.outerHeight();
	var columnHeightDifference = leftColumnHeight - rightColumnHeight;
	var heightAboveColumns = jQuery('.et_pb_mw_boxedist').offset().top;
	var heightNotVisible = jQuery('.et_pb_mw_boxedist').outerHeight() - jQuery(window).innerHeight();
	var scrollInterval = heightNotVisible / columnHeightDifference;
	var currentScrollbarPosition = jQuery(this).scrollTop();

	// Determine the offset, or gap that we should insert above the left column to push it down to where we want it to be
	var amountToOffsetRightColumn = Math.min(

		// Whichever is greater out of zero or the calculated offset
		Math.max(0, Math.round((currentScrollbarPosition - heightAboveColumns) / scrollInterval)),

		// The maximum offset we can allow without the right column moving too low
		columnHeightDifference
	);

	// Set the offset
	jQuery(".right").css({ transform: "translate3d(0px, " + amountToOffsetRightColumn + "px, 0px)" });
});
