<?php

    namespace Optimus\Divi\Modules\Redirect;

    use Optimus\Divi\Modules\BaseModule as DiviModule;
    use ET_Builder_Element;

    class Module extends DiviModule
    {
        public $name = 'Redirect';

        public function init()
        {
            $this->slug = 'redirect';

            parent::init();
        }

        public function get_advanced_fields_config()
        {
            $advanced_fields = [];
            $advanced_fields['border'] = [];
            $advanced_fields['animation'] = [];
            $advanced_fields['background'] = [];
            return $advanced_fields;
        }


        public function get_fields()
        {
            return [
                'url' => [
                    'label' => 'Link',
                    'type' => 'text',
                ],
                'admin_label' => [
                    'label' => 'Admin Label',
                    'type' => 'text',
                    'description' => __(
                        'This will change the label of the module in the builder for easy identification.',
                        'et_builder'
                    ),
                ],
                'module_id' => [
                    'label' => __('CSS ID', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'tab_slug' => 'custom_css',
                    'option_class' => 'et_pb_custom_css_regular',
                ],
                'module_class' => [
                    'label' => __('CSS Class', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'tab_slug' => 'custom_css',
                    'option_class' => 'et_pb_custom_css_regular',
                ],
            ];
        }

        public function render($atts, $content, $render_slug)
        {
            $url = $this->props['url'];

            $output = sprintf('
		<script>window.location.replace("%1$s");</script>',
                $url
            );

            return $output;
        }
    }
