<?php

    namespace Optimus\Divi\Modules\SimpleImageSlider;

    use Optimus\Divi\Modules\BaseModule as DiviModule;
    use ET_Builder_Element;

    class Module extends DiviModule
    {

        public $name = 'Simple Image Slider';
        public $vb_support = "partial";

        public function init()
        {
            $this->child_slug = $this->slugify('Image Slide');
            $this->child_item_text = 'Slide';
            parent::init();
        }

        public function get_custom_css_fields_config() {
            return [
                'slide' => [
                    'label' => esc_html__('Slide', 'et_builder'),
                    'selector' => '.liteslider .item',
                ],
                'slide_img' => [
                    'label' => esc_html__('Slide Image', 'et_builder'),
                    'selector' => '.liteslider .item img',
                ],
                'slide_img_hover' => [
                    'label' => esc_html__('Slide Image Hover', 'et_builder'),
                    'selector' => '.liteslider .item:hover img',
                ],
            ];
        }

        public function get_advanced_fields_config()
        {
            $advanced_fields = [];
            $advanced_fields['border'] = [];
            $advanced_fields['animation'] = [];
            $advanced_fields['margin_padding'] = [
                'css' => [
                    'padding' => "{$this->main_css_element} .slick-slide",
                    'margin' => "{$this->main_css_element} .slick-slide",
                ],
            ];
            $advanced_fields['background'] = [
                'css' => array(
                    'main' => "{$this->main_css_element} .slick-slide",
                ),
            ];
            return $advanced_fields;
        }

        public function get_fields()
        {
            return [
                'slider_speed' => [
                    'label' => esc_html__('Scroll speed (milliseconds)', 'et_builder'),
                    'type' => 'range',
                    'option_category' => 'layout',
                    'default' => '2000',
                    'range_settings' => [
                        'min' => '250',
                        'max' => '10000',
                        'step' => '250',
                    ],
                    'tab_slug' => 'advanced',
                ],
                'slider_intival' => [
                    'label' => esc_html__('Scroll interval (milliseconds)', 'et_builder'),
                    'type' => 'range',
                    'option_category' => 'layout',
                    'default' => '2000',
                    'range_settings' => [
                        'min' => '0',
                        'max' => '10000',
                        'step' => '100',
                    ],
                    'tab_slug' => 'advanced',
                ],

                'slides_to_show' => [
                    'label' => esc_html__('Slides to show', 'et_builder'),
                    'type'            => 'range',
                    'option_category' => 'layout',
                    'default' => '4',
                    'mobile_options'  => true,
                    'tab_slug'        => 'advanced',
                    'responsive'      => true,
                    'default_unit'    => '',
                    'range_settings' => [
                        'min' => '0',
                        'max' => '10',
                        'step' => '.1',
                    ],
                ],

                'gutter' => [
                    'label' => esc_html__('Gutter', 'et_builder'),
                    'type'            => 'range',
                    'option_category' => 'layout',
                    'default' => '10px',
//                     'mobile_options'  => true,
                    'tab_slug'        => 'advanced',
//                     'responsive'      => true,
                    'default_unit'    => 'px',
                    'range_settings' => [
                        'min' => '0',
                        'max' => '100',
                        'step' => '1',
                    ],
                ],

                'slider_direction' => [
                    'label' => esc_html__('Slider Direction', 'et_builder'),
                    'type' => 'select',
                    'tab_slug'        => 'advanced',
                    'options' => [
                        'right' => esc_html__('Right', 'et_builder'),
                        'left' => esc_html__('Left', 'et_builder'),
                    ],
                ],
            // todo write php to randomize child module order
                        /*
                                        'randomize_order_on_pageload' => [
                                            'label' => esc_html__('Randomize order of slides on page load', 'et_builder'),
                                            'type' => 'yes_no_button',
                                            'tab_slug'        => 'advanced',
                                            'options' => [
                                                'off' => esc_html__('No', 'et_builder'),
                                                'on' => esc_html__('Yes', 'et_builder'),
                                            ],
                                        ],
                        */
                'grey_out' => [
                    'label' => esc_html__('Grey Out Logos', 'et_builder'),
                    'type' => 'select',
                    'option_category' => 'configuration',
                    'options' => [
                        '' => esc_html__('Never', 'et_builder'),
                        'grayscale' => esc_html__('Always', 'et_builder'),
                        'grayscale_hover' => esc_html__('On Hover', 'et_builder'),
                        'grayscale_hover_alt' => esc_html__('Not Hovered', 'et_builder'),
                    ],
                    'tab_slug' => 'advanced',
                ],
            ];
        }

        public function before_render(){
            wp_enqueue_script('liteslider', $this->assetUrl('liteslider.js'), ['jquery'], '1.4.12' );
            wp_enqueue_style('liteslider', $this->assetUrl('liteslider.css'));
        }

        public function render($atts, $content, $render_slug)
        {
            $module_id = $this->props['module_id'];
            $module_class = $this->props['module_class'];
            $grey_out = $this->props['grey_out'];
            $gutter = $this->props['gutter'];
            $slider_intival = rtrim($this->props['slider_intival'],"px");
            $slider_direction = $this->props['slider_direction'];

            $module_class = trim(ET_Builder_Element::add_module_order_class($module_class, $render_slug));

            $slidesToShow = rtrim($this->props['slides_to_show'],"px");
            $slidesToShowtablet = rtrim($this->props['slides_to_show_tablet'],"px");
            $slidesToShowphone = rtrim($this->props['slides_to_show_phone'],"px");
            $randomizeOrder = isset($this->props['randomize_order_on_pageload']) && $this->props['randomize_order_on_pageload'] == 'on';
            $logos = $this->content;

            $sliderSpeed = (isset($this->props['slider_speed']) && !empty($this->props['slider_speed'])) ? $this->props['slider_speed'] : 2000;
            $sliderSpeed = rtrim($sliderSpeed ,"px");
            $output = sprintf(
                '<div %3$s class="%2$s et_pb_simple_image_slider  liteslider %4$s">
                    <div class="MS-content" data-interval="%9$s" data-duration="%10$s" data-direction="%11$s" data-gutter="%12$s" style="--slides: %5$s; --slides_tab: %6$s; --slides_mob: %7$s; --gutter: %8$s;">
                		%1$s
                	</div>
                </div>',
                $logos,
                ('' !== $grey_out ? $grey_out : ''),
                ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
                ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : ''),
                ('' !== $slidesToShow ? $slidesToShow : 4),
                ('' !== $slidesToShowtablet ? $slidesToShowtablet : 2),
                ('' !== $slidesToShowphone ?  $slidesToShowphone : 1),
                $gutter,
                $slider_intival,
                $sliderSpeed,
                $slider_direction,
                rtrim($gutter,"px")
            );
            return $output;
        }
    }