<?php

    namespace Optimus\Divi\Modules\SimpleImageSlider;

    use Optimus\Divi\Modules\BaseModule as DiviModule;
    use ET_Builder_Element;

    class Slide extends DiviModule
    {
        public $name = 'Image Slide';

        public function init()
        {
            $this->type = 'child';
            $this->child_title_var = 'title';
            $this->advanced_setting_title_text = 'Slide';
            $this->settings_text = 'Slide Settings';
            parent::init();
        }

        public function get_advanced_fields_config() {
            $advanced_fields = [];
            $advanced_fields['border'] = [];
            $advanced_fields['margin_padding'] = [
                'css'        => [
                    'padding'   => "{$this->main_css_element}",
                    'margin'    => "{$this->main_css_element}",
                    'important' => 'all',
                ],

            ];
            $advanced_fields['background'] = [
                'css' => array(
                    'main' => "{$this->main_css_element}",
                    'important' => 'all',
                ),
            ];
            return $advanced_fields;
        }

        public function get_fields()
        {
            return [
                'src' => [
                    'label' => 'Logo URL',
                    'type' => 'upload',
                    'option_category' => 'basic_option',
                    'upload_button_text' => esc_attr__('Upload an image', 'et_builder'),
                    'choose_text' => esc_attr__('Choose an Image', 'et_builder'),
                    'update_text' => esc_attr__('Set As Image', 'et_builder'),
                    'description' => 'Upload your desired logo, or type in the URL to the image you would like to display.',
                ],
                'title' => [
                    'label' => 'Text',
                    'type' => 'text',
                    'description' => 'This will make the slide identifiable it will also be used for alt text.',
                ],
                'link' => [
                    'label' => 'URL',
                    'type' => 'text',
                    'description' => 'Here you can define the url of the link.',
                ],
                'url_new_window' => [
                    'label' => esc_html__('Url Opens', 'et_builder'),
                    'type' => 'select',
                    'option_category' => 'configuration',
                    'options' => [
                        'on' => esc_html__('In The New Tab', 'et_builder'),
                        'off' => esc_html__('In The Same Window', 'et_builder'),
                    ],
                    'description' => esc_html__(
                        'Here you can choose whether or not your link opens in a new window',
                        'et_builder'
                    ),
                ],
            ];
        }

        public function render($atts, $content, $render_slug)
        {
            $title = $this->props['title'];
            $link = $this->props['link'];
            $src = $this->props['src'];
            $url_new_window = $this->props['url_new_window'];
            $module_class = ET_Builder_Element::add_module_order_class('', $render_slug);

            $et_pb_tab_titles[] = '' !== $title ? $title : __('Tab', 'et_builder');
            $et_pb_tab_classes[] = $module_class;

            if ('' !== $link) {
                $link = sprintf(
                    '<a href="%1$s" %2$s>',
                    $link,
                    ('off' === $url_new_window ? '' : ' target="_blank"')
                );
            }

            return sprintf(
                '<div class="et_pb_image_slide item %5$s"> %2$s<img src="%4$s" alt="%1$s" title="%1$s" >%3$s	</div>',
                $title,
                $link,
                ('' !== $link ? '</a>' : ''),
                $src,
                $module_class
            );
        }
    }