// V1.4.12
(function($){
    $.fn.liteslider = function(data, callback){

        // ==== CACHE DOM ====
        var $liteslider = $(this);
        var $msContent = $liteslider.find('.MS-content');
        var $data = $msContent.data();
        var $msRight = $liteslider.find('button.MS-right');
        var $msLeft = $liteslider.find('button.MS-left');
        var $imgFirst = $msContent.find('.item:first');

        // === DETERMINE ACTION ====
        // string = method | object or nothing is to initialize
        if(typeof data === 'string'){
            getStringArgs(data);
            return $liteslider;
        } else if (typeof data === 'object' || typeof data  ==='undefined'){
            init();
        }

        // ==== PLUGGIN VARIABLES ====
        var $imgLast,
            totalWidth,
            numberVisibleSlides,
            animateDistance,
            animateSlideRight,
            animateSlideLeft,
            defaults,
            settings,
            animateDuration,
            autoSlideInterval;

        var ddata = $liteslider.data();

        // = INITIALIZE =
        function init(){
            minifyContent();        // minify html
            createSettings();       // merge defaults and user provided options
            saveData();             // add data object to DOM el with reference to animation functions, allows for methods to reference at any time
            selectAnimations();     // choose default animation
        }


        // ==== EVENT HANDLERS ====
        $msRight.on('click', animateSlideLeft);
        $msLeft.on('click', animateSlideRight);
        $liteslider.on('click','.MS-right, .MS-left', resetInterval);
        $(window).on('resize', findItemWidth);


        // ==== FUNCTIONS (for days...) ====

        function pauseAbove(){
            if (window.innerWidth > settings.pauseAbove){ $liteslider.addClass('ms-PAUSE'); }
            $(window).on('resize',function(){
                if (window.innerWidth > settings.pauseAbove){
                    $liteslider.addClass('ms-PAUSE');
                } else {
                    $liteslider.removeClass('ms-PAUSE');
                }
            });
        }

        function pauseBelow(){
            if (window.innerWidth < settings.pauseBelow){ $liteslider.addClass('ms-PAUSE'); }
            $(window).on('resize',function(){
                if (window.innerWidth < settings.pauseBelow){
                    $liteslider.addClass('ms-PAUSE');
                } else {
                    $liteslider.removeClass('ms-PAUSE');
                }
            });
        }

        // used if method is called after initialization
        function getStringArgs(str){
            if (typeof $liteslider.data(str) !== 'undefined'){
                $liteslider.data(str)();
            } else {
                console.error("liteslider currently only accepts the following methods: next, prev, pause, play");
            }
        }

        // saves data object to DOM element
        function saveData(){
            $liteslider.data({
                "pause":function(){ $liteslider.addClass('ms-PAUSE'); },
                "unPause":function(){ $liteslider.removeClass('ms-PAUSE'); },
                "continuous":function(){ $liteslider.removeClass('ms-PAUSE'); continuousLeft(); },
                "next":function(){ overRidePause(singleLeft); },
                "nextAll":function(){ overRidePause(allLeft); },
                "prev":function(){ overRidePause(singleRight); },
                "prevAll":function(){ overRidePause(allRight); },
                "settings":settings
            });
        }

        // used when calling 'next', 'prev' methods
        function overRidePause(animation){
            if ($liteslider.hasClass('ms-PAUSE')){
                $liteslider.removeClass('ms-PAUSE');
                animation();
                $liteslider.addClass('ms-PAUSE');
            } else {
                animation();
            }
            resetInterval();
        }

        // CRITICAL for items to be perfectly side-by-side without floating them
        function minifyContent(){
            $msContent.contents().filter(function(){
                return (this.nodeType == 3 && !/\S/.test(this.nodeValue));
            }).remove();
        }

        // updated options with defaults, measure slide widths for animation calculations, carry out setting implementations
        function createSettings() {
            defaults = settings || {
                continuous: false,	// endless scrolling with no pauses
                slideall: false,	// slide all visible slides, or just one at a time
                interval: 2000,		// time bewteen slide animation, 0 or 'false' prevents auto-sliding
                duration: 500,	    // duration of slide animation
                direction: "left", // direction of slide animation
                hoverPause: true,	// pause slideshow on hover
                pauseAbove: null,   // pause above specified screen width
                pauseBelow: null,    // pause below specified screen width
                easing: "swing",
                gutter: 10,
            };

            settings = $.extend({},defaults,data,$data);

            findItemWidth();
            animateDuration = settings.duration;

            if (settings.hoverPause){pauseHover();}
            autoSlide();
            if (settings.pauseAbove !== null && typeof settings.pauseAbove === 'number'){ pauseAbove(); }
            if (settings.pauseBelow !== null && typeof settings.pauseBelow === 'number'){ pauseBelow(); }
            if (settings.interval === 0){ settings.easing = "linear" }

        }

        // determine between single and multi-slide animations
        function selectAnimations () {
            animateSlideRight = $liteslider.data('prev');
            animateSlideLeft = $liteslider.data('next');
        }

        // measure slide width, for animation calculations
        function findItemWidth(){
            reTargetSlides();
            animateDistance = $imgFirst.width();
            animateDistance = ($imgFirst.width() + settings.gutter);
            autoSlide();
        }

        // recursive auto-slide loop
        function autoSlide() {
            totalWidth = $msContent.get(0).scrollWidth;
            sliderWidth = $msContent.width();
            if(totalWidth > sliderWidth){
                autoSlideInterval = setInterval(function(){
                    if (!$liteslider.hasClass('ms-PAUSE')){
                        if(settings.direction == "right"){
                            animateSlideLeft();
                        }else{
                            animateSlideRight();
                        }
                    }
                }, settings.interval);
            }else{
                clearInterval(autoSlideInterval);
            }
        }

        function resetInterval() {
            if (settings.interval !== 0 && settings.interval !== false && settings.continuous !== true){
                clearInterval(autoSlideInterval);
                autoSlide();
            }
        }

        // target first and last visible slides before each new animation
        function reTargetSlides(){
            $imgFirst = $msContent.find('.item:first');
            $imgLast = $msContent.find('.item:last');
        }

        // prevent animation firing if liteslider is currently animating
        // all animations pass through this function, which emits events, and adds/removes animating class
        function isItAnimating(callback){
            if(!$liteslider.hasClass('ms-animating') &&
                !$liteslider.hasClass('ms-HOVER') &&
                !$liteslider.hasClass('ms-PAUSE')){
                $liteslider.trigger('ms.before.animate'); // event!
                $liteslider.addClass('ms-animating');
                callback();    //callback is animation
            }
        }

        // update liteslider at the end of each animation
        function doneAnimating() {
            if($liteslider.hasClass('ms-animating')){
                $liteslider.removeClass('ms-animating');
                $liteslider.trigger('ms.after.animate'); // event!
            }
        }

        // logic for pausing and restarting the liteslider on hover
        function pauseHover() {
            $msContent.on('mouseover',function(){
                $liteslider.addClass('ms-HOVER');
            });
            $msContent.on('mouseout',function(){
                $liteslider.removeClass('ms-HOVER');
                autoSlide();
            });
        }

        // calculate remaining animation, if stopped mid-animation and resuming
        function midAnimateResume(){
            animateDuration = settings.duration;
            var currentMargin = parseFloat($msContent.find('.item:first').css("margin-left"));
            var percentageRemaining = 1-(currentMargin/-(animateDistance-1));
            animateDuration = percentageRemaining*animateDuration;
        }

        // determine how many slides need to be moved over, if slideall is true
        function calcNumSlidesToMove(){
            totalWidth = $msContent.width();						          // total width of .MS-content containing all visible slides
            numberVisibleSlides = Math.floor(totalWidth/animateDistance);     // number of (visible) slides needed to be moved in each animation
        }

        function singleLeft(){
            isItAnimating(function(){
                reTargetSlides();
                $imgFirst.animate(
                    {
                        marginLeft: -animateDistance
                    }, {
                        duration: animateDuration,
                        easing: settings.easing,
                        complete: function(){
                            $imgFirst.detach().removeAttr('style').appendTo($msContent);
                            doneAnimating();
                        }
                    }
                );
            });
        }

        function singleRight(){
            isItAnimating(function(){
                reTargetSlides();
                $imgLast.css('margin-left',-animateDistance).prependTo($msContent);
                $imgLast.animate(
                    {
                        marginLeft: 0
                    }, {
                        duration: animateDuration,
                        easing: settings.easing,
                        complete: function(){
                            $imgLast.removeAttr("style");
                            doneAnimating();
                        }
                    }
                );
            });
        }
        return $liteslider;
    }
})(jQuery);

jQuery( ".liteslider" ).each(function( index ) {
    jQuery( this ).liteslider();
});
