<?php

namespace Optimus\Divi\Modules\Timeline;

use Optimus\Divi\Modules\BaseModule as DiviModule;
use ET_Builder_Element;

class Item extends DiviModule
{
    public $name = 'Timeline Item';

    public function init()
    {
        $this->type = 'child';
        $this->child_title_var = 'title';
        $this->advanced_setting_title_text = 'New Item';
        $this->settings_text = 'Item Settings';

        parent::init();
    }

    public function fields()
    {
        return [
            'title' => [
                'label' => 'Title',
                'type' => 'text',
            ],
            'subtitle' => [
                'label' => 'Subtitle',
                'type' => 'text',
            ],
            'date' => [
                'label' => 'Date',
                'type' => 'text',
            ],
            'content_new' => [
                'label' => esc_html__('Content', 'et_builder'),
                'type' => 'tiny_mce',
                'option_category' => 'basic_option',
                'description' => esc_html__(
                    'Here you can create the content that will be used within the module.',
                    'et_builder'
                ),
            ],
            'src' => [
                'label' => esc_html__('Gallery Images', 'et_builder'),
                'renderer' => 'et_builder_get_gallery_settings',
                'option_category' => 'basic_option',
            ],
            'gallery_ids' => [
                'type' => 'hidden',
                'class' => ['et-pb-gallery-ids-field'],
            ],
            'gallery_orderby' => [
                'label' => esc_html__('Gallery Images', 'et_builder'),
                'type' => 'hidden',
                'class' => ['et-pb-gallery-ids-field'],
            ],
        ];
    }

    public function shortcode_callback($atts, $content, $function_name)
    {
        global $et_pb_tab_titles;
        global $et_pb_tab_classes;

        $title = $this->shortcode_atts['title'];
        $subtitle = $this->shortcode_atts['subtitle'];
        $src = $this->shortcode_atts['src'];
        $gallery_ids = $this->shortcode_atts['gallery_ids'];
        $date = $this->shortcode_atts['date'];

        $module_class = ET_Builder_Element::add_module_order_class('', $function_name);

        $et_pb_tab_classes[] = $module_class;
        $thumb = empty($athumb) ? $src : $athumb[0];

        $images = '';
        foreach (explode(',', $gallery_ids) as $gallery_id) {
            $images .= '<div class="image">'.wp_get_attachment_image($gallery_id).'</div>';
        }

        $output = sprintf(
            '
            <div class="item %5$s %6$s">
                <div class="desc">
                    <h2>%2$s %3$s</h2> 
                    %7$s
                    %8$s
                    %1$s
                </div>
                <div class="images">
                    %4$s
                </div>
            </div>',
            $this->shortcode_content,
            $title,
            ('' !== $date ? sprintf(' <span class="date">%1$s</span>', $date) : ''),
            $images,
            ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : ''),
            (1 === count($et_pb_tab_titles) ? ' et_pb_active_content' : ''),
            ('' !== $subtitle ? sprintf('<div>%1$s</div>', $subtitle) : ''),
            ('' !== $thumb ? sprintf('<img src="%1$s" class="thumbnail" />', $thumb) : '')
        );

        return $output;
    }
}
