<?php

namespace Optimus\Divi\Modules\Timeline;

use Optimus\Divi\Modules\BaseModule as DiviModule;
use ET_Builder_Element;

class Module extends DiviModule
{
    public $name = 'Timeline';

    protected $adminIconBackgroundSize = '35px';

    public function init()
    {
        $this->child_slug = $this->slugify('Timeline Item');
        $this->child_item_text = 'Timeline Item';

        parent::init();
    }

    public function fields()
    {
        return [
            'background_layout' => [
                'label' => esc_html__('Text Color', 'et_builder'),
                'type' => 'select',
                'option_category' => 'color_option',
                'options' => [
                    'light' => esc_html__('Dark', 'et_builder'),
                    'dark' => esc_html__('Light', 'et_builder'),
                ],
            ],
            'text_orientation' => [
                'label' => 'Align',
                'type' => 'select',
                'option_category' => 'layout',
                'options' => et_builder_get_text_orientation_options(),
                'description' => 'This will adjust the alignment of the element.',
            ],
            'admin_label' => [
                'label' => __('Admin Label', 'et_builder'),
                'type' => 'text',
                'description' => __(
                    'This will change the label of the module in the builder for easy identification.',
                    'et_builder'
                ),
            ],
            'module_id' => [
                'label' => __('CSS ID', 'et_builder'),
                'type' => 'text',
                'option_category' => 'configuration',
                'description' => __(
                    'Enter an optional CSS ID to be used for this module. An ID can be used to create custom CSS styling, or to create links to particular sections of your page.',
                    'et_builder'
                ),
            ],
            'module_class' => [
                'label' => __('CSS Class', 'et_builder'),
                'type' => 'text',
                'option_category' => 'configuration',
                'description' => __(
                    'Enter optional CSS classes to be used for this module. A CSS class can be used to create custom CSS styling. You can add multiple classes, separated with a space.',
                    'et_builder'
                ),
            ],
        ];
    }

    public function shortcode_callback($atts, $content, $function_name)
    {
        $module_id = $this->shortcode_atts['module_id'];
        $module_class = $this->shortcode_atts['module_class'];
        $background_layout = $this->shortcode_atts['background_layout'];
        $text_orientation = $this->shortcode_atts['text_orientation'];

        $module_class = ET_Builder_Element::add_module_order_class($module_class, $function_name);

        $all_tiles_content = $this->shortcode_content;

        global $et_pb_tab_titles;
        global $et_pb_tab_classes;
        $class = " et_pb_module et_pb_bg_layout_{$background_layout} et_pb_text_align_{$text_orientation}";

        $et_pb_tab_titles = $et_pb_tab_classes = [];

        $output = sprintf(
            '
            <div class="et_pb_mw_timeline %4$s">
                <div class="timeline group">
                    %1$s
                </div>
            </div>',
            $all_tiles_content,
            ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
            ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : ''),
            $class
        );

        wp_enqueue_style('timeline', $this->assetUrl('timeline.css'));

        return $output;
    }
}
