<?php

namespace Optimus\Divi\Modules\TripAdvisor;

use Optimus\Divi\Modules\BaseModule as DiviModule;
use ET_Builder_Element;

class Module extends DiviModule
{
    public $name = 'TripAdvisor';

    public function init()
    {
        $this->fields_defaults = [
            'show_rating' => ['on'],
            'show_pos'    => ['on'],
            'review_link' => ['off'],
        ];

        parent::init();
    }

    public function fields()
    {
        return [
            'location_id'  => [
                'label'       => 'Location ID',
                'type'        => 'text',
                'description' => 'Your Location ID',
            ],
            'show_rating'  => [
                'label'   => 'Show Rating',
                'type'    => 'yes_no_button',
                'options' => [
                    'off' => 'No',
                    'on'  => 'Yes',
                ],
            ],
            'show_pos'     => [
                'label'   => 'Show Position',
                'type'    => 'yes_no_button',
                'options' => [
                    'off' => 'No',
                    'on'  => 'Yes',
                ],
            ],
            'review_count' => [
                'label'       => 'Review Count',
                'line_height' => [
                    'range_settings' => [
                        'min'  => '1',
                        'max'  => '10',
                        'step' => '1',
                    ],
                ],
            ],
            'review_link'  => [
                'label'   => 'Write Review Link',
                'type'    => 'yes_no_button',
                'options' => [
                    'off' => 'No',
                    'on'  => 'Yes',
                ],
            ],
            'admin_label'  => [
                'label'       => __('Admin Label', 'et_builder'),
                'type'        => 'text',
                'description' => __('This will change the label of the module in the builder for easy identification.',
                    'et_builder'),
            ],
            'module_id'    => [
                'label'           => __('CSS ID', 'et_builder'),
                'type'            => 'text',
                'option_category' => 'configuration',
                'description'     => __('Enter an optional CSS ID to be used for this module. An ID can be used to create custom CSS styling, or to create links to particular sections of your page.',
                    'et_builder'),
            ],
            'module_class' => [
                'label'           => __('CSS Class', 'et_builder'),
                'type'            => 'text',
                'option_category' => 'configuration',
                'description'     => __('Enter optional CSS classes to be used for this module. A CSS class can be used to create custom CSS styling. You can add multiple classes, separated with a space.',
                    'et_builder'),
            ],
        ];
    }

    public function shortcode_callback($atts, $content, $function_name)
    {
        $module_id    = $this->shortcode_atts['module_id'];
        $module_class = $this->shortcode_atts['module_class'];
        $location_id  = $this->shortcode_atts['location_id'];
        $show_rating  = $this->shortcode_atts['show_rating'];
        $show_pos     = $this->shortcode_atts['show_pos'];
        $review_link  = $this->shortcode_atts['review_link'];
        $review_count = $this->shortcode_atts['review_count'];
        $module_class = ET_Builder_Element::add_module_order_class($module_class, $function_name);

        $output = sprintf(
            '<div id="TA_selfserveprop600" class="TA_selfserveprop %7$s">
                <ul id="1bOocrJqori" class="TA_links cpz70Zx">
                    <li id="LjjnBL" class="Aj3Q8vw7zRCx">
                        <a target="_blank" href="https://www.tripadvisor.com.au/">
                            <img src="https://www.tripadvisor.com.au/img/cdsi/img2/branding/150_logo-11900-2.png" alt="TripAdvisor"/>
                        </a>
                    </li>
                </ul>
            </div>
            <script src="https://www.jscache.com/wejs?wtype=selfserveprop&amp;uniq=600&amp;locationId=%1$s&amp;lang=en_AU&amp;%2$snreviews=%3$s&amp;%4$s%5$siswide=true&amp;border=false&amp;display_version=2"></script>',
            $location_id,
            ('on' !== $show_rating ? 'rating=false&amp;' : 'rating=true&amp;'),
            $review_count,
            ('on' !== $review_link ? '' : 'writereviewlink=true&amp;'),
            ('on' !== $show_pos ? '' : 'popIdx=true&amp;'),
            ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
            ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : '')
        );

        wp_enqueue_style('tripadvisor', $this->assetUrl('tripadvisor.css'));

        return $output;
    }
}
