<?php
    namespace Optimus\Divi\Modules\VideoPopup;

    use Optimus\Divi\Modules\BaseModule as DiviModule;
    use ET_Builder_Element;

    class Module extends DiviModule
    {
        public $name = 'Video Popup';
        public $vb_support = "partial";

        public function init()
        {
            $this->custom_css_fields = [
                'main_element' => [
                    'label' => esc_html__('Main Element', 'et_builder'),
                    'selector' => '.et_pb_video_popup_wrapper',
                    'no_space_before_selector' => TRUE,
                ]
            ];
            parent::init();
        }

        public function fields()
        {
            return [
                'video_url' => [
                    'label' => 'Video Url',
                    'type' => 'text',
                    'option_category' => 'basic_option',
                    'description' => 'Enter your YouTube or Vimeo URL. Note that it needs to be in an <a href="https://optimusdivi.com/video-popup-module-accepted-url-formats/" target="_blank"> accepted format, which you can read about here.</a>',
                ],
                'video_popup_width' => [
                    'label' => 'Width of Video Popup',
                    'type' => 'range',
                    'allowed_units'    => array( '%', 'em', 'rem', 'px', 'cm', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw' ),
                    'default'          => '900',
                    'default_unit'     => 'px',
                    'default_on_front' => '',
                    'range_settings'   => array(
                        'min'  => '0',
                        'max'  => '1200',
                        'step' => '1',
                    ),
                    'option_category' => 'basic_option',
                    'description' => 'Set the width of the video popup modal (default 900px)',
                ],
                'background_img' => [
                    'label' => 'Background/Placeholder Image',
                    'type' => 'upload',
                    'option_category' => 'basic_option',
                    'upload_button_text' => esc_attr__('Upload an image', 'et_builder'),
                    'choose_text' => esc_attr__('Choose an Image', 'et_builder'),
                    'update_text' => esc_attr__('Set As Image', 'et_builder'),
                    'description' => 'For best results ensure that this image is at least as big as the column that it is nestled inside.',
                ],
                'play_img' => [
                    'label' => 'Play Image',
                    'type' => 'upload',
                    'option_category' => 'basic_option',
                    'upload_button_text' => esc_attr__('Upload an image', 'et_builder'),
                    'choose_text' => esc_attr__('Choose an Image', 'et_builder'),
                    'update_text' => esc_attr__('Set As Image', 'et_builder'),
                    'description' => 'You can upload your own image file, or <a href="https://optimusdivi.com/video-popup-play-button-icon-library/" target="_blank">make a selection from our library.</a>'
                ],
                'play_img_hover' => [
                    'label' => 'Play Image Hover State',
                    'type' => 'upload',
                    'option_category' => 'basic_option',
                    'upload_button_text' => esc_attr__('Upload an image', 'et_builder'),
                    'choose_text' => esc_attr__('Choose an Image', 'et_builder'),
                    'update_text' => esc_attr__('Set As Image', 'et_builder'),
                    'description' => 'As above, select a file that is slightly different from the play button to create a hover effect for the user.',
                ],
                'show_related' => [
                    'label' => 'Show Related Videos',
                    'type' => 'select',
                    'option_category' => 'basic_option',
                    'options' => [
                        'off' => 'No',
                        'on' => 'Yes',
                    ],
                    'description' => '(This option currently only affects YouTube videos.)',
                ],
                'auto_close' => [
                    'label' => 'Autoclose',
                    'type' => 'select',
                    'option_category' => 'basic_option',
                    'options' => [
                        FALSE => 'No',
                        TRUE => 'Yes',
                    ],
                    'description' => '(This option currently only affects YouTube videos.)',
                ],
                'module_id' => [
                    'label' => esc_html__('CSS ID', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'tab_slug' => 'custom_css',
                    'option_class' => 'et_pb_custom_css_regular',
                ],
                'module_class' => [
                    'label' => esc_html__('CSS Class', 'et_builder'),
                    'type' => 'text',
                    'option_category' => 'configuration',
                    'tab_slug' => 'custom_css',
                    'option_class' => 'et_pb_custom_css_regular',
                ],
            ];
        }

        public function render($atts, $content, $render_slug)
        {
            $module_id = $this->shortcode_atts['module_id'];
            $module_class = $this->shortcode_atts['module_class'];
            $video_url = $this->shortcode_atts['video_url'];
            $background_img = $this->shortcode_atts['background_img'];
            $play_img = $this->shortcode_atts['play_img'];
            $play_img_hover = $this->shortcode_atts['play_img_hover'];
            $show_related = $this->shortcode_atts['show_related'];
            $auto_close = $this->shortcode_atts['auto_close'];
            $video_popup_width = $this->props['video_popup_width'];

            $background_img_id = attachment_url_to_postid($background_img);
            $play_img_id = attachment_url_to_postid($play_img);
            $play_btn = wp_get_attachment_image( $play_img_id, "full", false, array('data-alt-src'=>$play_img_hover) );

            $module_class = ET_Builder_Element::add_module_order_class($module_class, $render_slug);

            $output = sprintf(
                '<div %5$s class="et_pb_video_popup_wrapper et_pb_video_popup %6$s et_pb_module">
                <a class="et_pb_video_popup video-popup" href="%1$s">
                    <div class="video_thumbnail">
                        %2$s
                        <span class="play-btn">
                            %3$s
                        </span>
                    </div>
                </a>
            </div><style>.mfp-iframe-holder .mfp-content {  max-width: %7$s !important;}</style>',
                esc_url($video_url),
                wp_get_attachment_image( $background_img_id, 'full' ),
                $play_btn,
                $play_img_hover,
                ('' !== $module_id ? sprintf(' id="%1$s"', esc_attr($module_id)) : ''),
                ('' !== $module_class ? sprintf(' %1$s', esc_attr($module_class)) : ''),
                $video_popup_width
            );
            // todo check for video location before loading scripts
            if (!is_admin()) {
                wp_enqueue_style('vidpopup-style', $this->assetUrl('vidpopup.css'));
                wp_enqueue_script('jquery-magnific-popup', $this->assetUrl('jquery.magnific-popup.min.js'));
                wp_enqueue_script('vidpopup_module', $this->assetUrl('vidpopup.js'), ['jquery-magnific-popup'],'1.1.0');
                wp_enqueue_script('YTAPI', '//www.youtube.com/iframe_api');
                wp_localize_script(
                    'vidpopup_module',
                    'vp_vars',
                    [
                        'rel' => ('on' !== $show_related ? sprintf('&rel=0', esc_attr($show_related)) : ''),
                        'modestbranding' => '&modestbranding=1',
                        'fullscreen' => '&fs=0',
                        'autoclose' => $auto_close
                    ]
                );

            }

            return $output;
        }
    }