var sourceSwap = function () {
    var $this = jQuery(this).find(".play-btn img");
    var newSource = $this.data('alt-src');
    $this.data('alt-src', $this.attr('src'));
    $this.attr('src', newSource);
}

jQuery(function() {
    jQuery('.video_thumbnail').each(function() {
    }).hover(sourceSwap, sourceSwap);
});

jQuery(document).ready(function() {
    if (typeof magnificPopup == 'function') { }else{
        $.getScript("jquery.magnific-popup.min.js");
    }
    jQuery(".video-popup").magnificPopup({
        type: "iframe",
        iframe: {
            markup: '<div class="mfp-iframe-scaler">'+
                '<div class="mfp-close"></div>'+
                '<iframe id="player" class="mfp-iframe" frameborder="0" allow="autoplay; fullscreen"></iframe>'+
                '</div>',

            patterns: {
                youtube: {
                    index: 'youtube.com/',
                    id: 'v=',
                    src: '//www.youtube.com/embed/%id%?autoplay=1&enablejsapi=1'+vp_vars.rel+vp_vars.modestbranding+vp_vars.fullscreen },
                vimeo: {
                    index: 'vimeo.com/',
                    id: '/',
                    src: '//player.vimeo.com/video/%id%?autoplay=1'
                },
                gmaps: {
                    index: '//maps.google.',
                    src: '%id%&output=embed'
                }
            },
            srcAction: 'iframe_src',
        },
        callbacks: {
            open: function() {
                new YT.Player('player', {
                    events: {
                        'onStateChange': onPlayerStateChange
                    }
                });
            }
        }
    });
});

function onPlayerStateChange(event) {
    if (vp_vars.autoclose != 0){
        if (event.data == YT.PlayerState.ENDED) {
            jQuery.magnificPopup.close();
        }
    }
}