<?php
    /**
     * Plugin Name: Optimus Divi Module Suite
     * Plugin URI: http://optimusdivi.com
     * Description: All Optimus Divi page builder modules in one handy portable plugin.
     * Version: 1.1.42
     * Author: Optimus Divi
     * Author URI: https://optimusdivi.com
     **/

    if (!defined('WPINC')) { die; }
    require __DIR__ . '/vendor/autoload.php';

    function suite_module_refine_loader()
    {
        wp_enqueue_style('module_refine_admin_css', plugin_dir_url(__FILE__) . 'admin.css', "", "1.1.42");
        wp_enqueue_script('module_refine_admin_js', plugin_dir_url(__FILE__) . 'admin.js', "", "1.1.42");
    }

    add_action('admin_print_scripts-post-new.php', 'suite_module_refine_loader');
    add_action('admin_print_scripts-post.php', 'suite_module_refine_loader');

    // Register the modules
    add_action('et_builder_ready', function () {
        new Optimus\Divi\Modules\AppleTVTile\Module(__FILE__);
        new Optimus\Divi\Modules\BeforeAndAfter\Module(__FILE__);
        new Optimus\Divi\Modules\BoxedList\Module(__FILE__);
        new Optimus\Divi\Modules\BoxedList\Item(__FILE__);
        new Optimus\Divi\Modules\BuyNow\Module(__FILE__);
        new Optimus\Divi\Modules\CalderaForms\Module(__FILE__);
        new Optimus\Divi\Modules\FullwidthBreadcrumbs\Module(__FILE__);
        new Optimus\Divi\Modules\GoogleMapWithStyle\Module(__FILE__);
        new Optimus\Divi\Modules\HeadingRotator\Module(__FILE__);
        new Optimus\Divi\Modules\HeadingRotator\Item(__FILE__);
        new Optimus\Divi\Modules\HoverTile\Module(__FILE__);
        new Optimus\Divi\Modules\ImagePlus\Module(__FILE__);
        new Optimus\Divi\Modules\LogoSlider\Module(__FILE__);
        new Optimus\Divi\Modules\LogoSlider\Slide(__FILE__);
        new Optimus\Divi\Modules\ModalButton\Module(__FILE__);
        new Optimus\Divi\Modules\ParallaxColumns\Module(__FILE__);
        new Optimus\Divi\Modules\Timeline\Module(__FILE__);
        new Optimus\Divi\Modules\TripAdvisor\Module(__FILE__);
        new Optimus\Divi\Modules\VideoPopup\Module(__FILE__);
        new Optimus\Divi\Modules\SimpleImageSlider\Module(__FILE__);
        new Optimus\Divi\Modules\SimpleImageSlider\Slide(__FILE__);
        new Optimus\Divi\Modules\ConditionalRedirect\Module(__FILE__);
        new Optimus\Divi\Modules\ConditionalRedirect\Condition(__FILE__);
        new Optimus\Divi\Modules\Redirect\Module(__FILE__);
        new Optimus\Divi\Modules\LoginForm\Module(__FILE__);
        new Optimus\Divi\Modules\EmbededGoogleMap\Module(__FILE__);
        new Optimus\Divi\Modules\FlickityInlineGallerySlider\Module(__FILE__);
        new Optimus\Divi\Modules\FlickityGallerySlider\Module(__FILE__);
        new Optimus\Divi\Modules\FlickityGallerySlider\ModuleFW(__FILE__);

        // Dynamic modules from theme
        $directories = glob(get_stylesheet_directory() . '/[Mm][Oo][Dd][Uu][Ll][Ee][Ss]/*', GLOB_ONLYDIR);
        foreach ($directories as $filename) {
            if (file_exists($filename . '/src/init.php')) {
                include_once($filename . '/src/init.php');
            }
        }
    });

    if (!function_exists("getme_url")) {
        function getme_url($loc){
            $wp_root_url = get_site_url();
            $wp_root_path = str_replace('/wp-content/themes', '', get_theme_root());
            $location = $loc;
            $location = str_replace(array('/', '\\'), DIRECTORY_SEPARATOR, $location);
            $url = str_replace($wp_root_path, $wp_root_url, $location);
            return $url;
        }
    }

////////////////////////// UPDATES //////////////////////////
if (class_exists('makeUpdate')) {
    try {
        $updater = new makeUpdate("9557", "ged.TDU_gva.zku0zcp", __FILE__);
    } catch (Exception $e) {
        // Silently ignore updater initialization errors to avoid breaking the plugin
    }
}