<?php
/**
 * Portfolio Details ACF Fields
 *
 * @package portfolio_pack
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Register ACF fields for the Portfolio Details
 * This field group is designed to be cloned into the main portfolio fields
 * 
 * Note: A more robust version of this implementation is archived in the 'archive' directory.
 * The archived version allows for field group creation and editing through the ACF UI.
 */
function pp_register_portfolio_details_fields() {
    // Check if helper function exists
    if (!function_exists('pp_create_acf_field_group')) {
        return;
    }

    // Check if field group exists
    $group_key = 'group_66f38f34bb31f';
    $existing_group = null;

    if (function_exists('acf_get_field_group')) {
        $existing_group = acf_get_field_group($group_key);
    }

    // If field group doesn't exist, create it
    if (!$existing_group) {
        // Create field group using helper
        $group_title = 'Portfolio Details Fields';
        $location = array(
            array(
                array(
                    'param' => 'post_type',
                    'operator' => '==',
                    'value' => 'portfolio',
                ),
            ),
        );

        // Create the field group with active set to false
        // This prevents it from showing up directly in the edit screen
        // but still allows it to be cloned into other field groups
        pp_create_acf_field_group($group_key, $group_title, $location, false);
    }
}

// Register the field group
add_action('acf/init', 'pp_register_portfolio_details_fields');
